package org.simantics.scl.compiler.elaboration.query;

import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.errors.Locations;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public abstract class QAbstractModifier extends Query {
    public Query query;
    
    public QAbstractModifier(Query query) {
        this.query = query;
    }

    public void collectFreeVariables(THashSet<Variable> vars) {
        query.collectFreeVariables(vars);
    }
    
    @Override
    public Query resolve(TranslationContext context) {
        query = query.resolve(context);
        return this;
    }

    @Override
    public void checkType(TypingContext context) {
        query.checkType(context);
    }
    
    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs,
            TIntHashSet refs) {
        query.collectRefs(allRefs, refs);
    }
    
    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars,
            TIntHashSet vars) {
        query.collectVars(allVars, vars);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            query.setLocationDeep(loc);
        }
    }
    
    @Override
    public void forVariables(VariableProcedure procedure) {
        query.forVariables(procedure);
    }
}
