package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.internal.parsing.Symbol;

public class GuardedExpression extends Symbol {
    public Expression[] guards;
    public Expression value;
    
    public GuardedExpression(Expression[] guards, Expression value) {
        this.guards = guards;
        this.value = value;
    }

    public GuardedExpression replace(ReplaceContext context) {
        return new GuardedExpression(
                Expression.replace(context, guards), 
                value.replace(context));
    }

    public void decorate(ExpressionDecorator decorator) {
        for(int i=0;i<guards.length;++i)
            guards[i] = guards[i].decorate(decorator);
        value = value.decorate(decorator);
    }

    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            for(Expression guard : guards)
                guard.setLocationDeep(loc);
            value.setLocationDeep(loc);
        }
    }

    public void forVariables(VariableProcedure procedure) {
        for(Expression guard : guards)
            guard.forVariables(procedure);
        value.forVariables(procedure);
    }
}
