package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public class ETypeAnnotation extends SimplifiableExpression {
    Expression value;
    Type type;
    TypeAst typeAst;
        
    public ETypeAnnotation(Expression value, TypeAst typeAst) {
        this.value = value;
        this.typeAst = typeAst;
    }

    public ETypeAnnotation(long loc, Expression value, Type type) {
        super(loc);
        this.value = value;
        this.type = type;
    }

	public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        value.collectRefs(allRefs, refs);
    }
	
	@Override
	public void collectVars(TObjectIntHashMap<Variable> allVars,
	        TIntHashSet vars) {
	    value.collectVars(allVars, vars);
	}

	@Override
	protected void updateType() throws MatchException {
	    setType(type);
	}

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        value.collectFreeVariables(vars);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        return value.simplify(context);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        value = value.resolve(context);
        type = context.toType(typeAst);
        return this;
    }
    
    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        value = value.resolveAsPattern(context);
        type = context.toType(typeAst);
        return this;
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        return value.checkType(context, type);
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        value = value.decorate(decorator);
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        value.collectEffects(effects);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            value.setLocationDeep(loc);
        }
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
    
    public Expression getValue() {
        return value;
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        value.forVariables(procedure);
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

}
