package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public class EGetConstraint extends SimplifiableExpression {
    TPred constraint;
    EVariable evidence;
        
    public EGetConstraint(long loc, TPred constraint) {
        super(loc);
        this.constraint = constraint;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs,
            TIntHashSet refs) {
    }
    
    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars,
            TIntHashSet vars) {
        if(evidence != null)
            evidence.collectVars(allVars, vars);        
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        Variable variable = new Variable("evidence");
        variable.setType(constraint);
        evidence = new EVariable(getLocation(), variable);
        evidence.setType(variable.getType());
        context.addConstraintDemand(evidence);
        return this;
    }
    
    @Override
    protected void updateType() throws MatchException {
        setType(constraint);
    }
    
    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        if(evidence != null)
            evidence.collectFreeVariables(vars);
    }
    
    @Override
    public Expression simplify(SimplificationContext context) {
        return evidence.simplify(context);
    }
    
    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }
    
    @Override
    public Expression decorate(ExpressionDecorator decorator) {     
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            if(evidence != null)
                evidence.setLocationDeep(loc);
        }
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        evidence.forVariables(procedure);
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

}
