package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.LhsType;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public abstract class DecoratingExpression extends SimplifiableExpression {
    public Expression expression;
    
    public DecoratingExpression(long loc, Expression expression) {
        super(loc);
        this.expression = expression;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        expression.collectRefs(allRefs, refs);
    }
    
    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars,
            TIntHashSet vars) {
        expression.collectVars(allVars, vars);
    }

    @Override
    protected void updateType() throws MatchException {
        setType(expression.getType());        
    }
    
    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        expression.collectFreeVariables(vars);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        expression = expression.simplify(context);
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        expression = expression.resolve(context);
        return this;
    }
    
    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        expression = expression.resolveAsPattern(context);
        return this;
    }
    
    @Override
    public EVar getPatternHead() throws NotPatternException {
        return expression.getPatternHead();
    }
    
    @Override
    public LhsType getLhsType() throws NotPatternException {
        return expression.getLhsType();
    }
    
    @Override
    public void getParameters(TranslationContext translationContext,
            ArrayList<Expression> parameters) {
        expression.getParameters(translationContext, parameters);
    }

    @Override
    public int getFunctionDefinitionPatternArity() throws NotPatternException {
        return expression.getFunctionDefinitionPatternArity();
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        expression = expression.decorate(decorator);
        return this;
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        expression.collectEffects(effects);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            expression.setLocationDeep(loc);
        }
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        expression.forVariables(procedure);
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        throw new InternalCompilerError("Cannot generate code for " + getClass().getSimpleName() + ".");
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        expression = expression.inferType(context);
        return this;
    }
    
    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        expression = expression.checkBasicType(context, requiredType);
        return this;
    }
    
    @Override
    public Expression checkIgnoredType(TypingContext context) {
        expression = expression.checkIgnoredType(context);
        return this;
    }
    
    @Override
    public int getSyntacticFunctionArity() {
        return expression.getSyntacticFunctionArity();
    }
}
