package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public abstract class ASTExpression extends SimplifiableExpression {
    public ASTExpression() {
    }
    
    @Override
    final public Expression simplify(SimplificationContext context) {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support simplify.");
    }
    
    @Override
    final public void collectFreeVariables(THashSet<Variable> vars) {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support collectFreeVariables.");

    }
    
    @Override
    final public void collectRefs(TObjectIntHashMap<Object> allRefs,
            TIntHashSet refs) {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support collectRefs.");
    }
    
    @Override
    final public void collectVars(TObjectIntHashMap<Variable> allVars,
            TIntHashSet vars) {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support collectVars.");
    }
    
    @Override
    final protected void updateType() throws MatchException {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support updateType.");
    }
    
    @Override
    final public Expression decorate(ExpressionDecorator decorator) {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support decorate.");
    }
    
    @Override
    final public void collectEffects(THashSet<Type> effects) {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support collectEffects.");
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support accept.");
    }
    
    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        throw new InternalCompilerError("Class " + 
                getClass().getSimpleName() + " does not implement method checkBasicType.");
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        throw new InternalCompilerError("Class " + 
                getClass().getSimpleName() + " does not implement method inferType.");
    }
    
    @Override
    public void forVariables(VariableProcedure procedure) {
        throw new InternalCompilerError("Class " + 
                getClass().getSimpleName() + " does not implement method forVariables.");
    }
}
