package org.simantics.scl.compiler.elaboration.equation;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public class EqBasic extends Equation {
    public Expression left;
    public Expression right;
    
    public EqBasic(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
    
    public EqBasic(long location, Expression left, Expression right) {
        this(left, right);
        this.location = location;
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            left.setLocationDeep(loc);
            right.setLocationDeep(loc);
        }
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        left.forVariables(procedure);
        right.forVariables(procedure);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        left.collectFreeVariables(vars);
        right.collectFreeVariables(vars);
    }

    @Override
    public void decorate(ExpressionDecorator decorator) {
        left = left.decorate(decorator);
        right = right.decorate(decorator);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        left.collectEffects(effects);
        right.collectEffects(effects);
    }

    @Override
    public void checkType(TypingContext context) {
        left = left.inferType(context);
        right = right.checkType(context, left.getType());
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        left.collectRefs(allRefs, refs);
        right.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        left.collectVars(allVars, vars);
        right.collectVars(allVars, vars);
    }

    @Override
    public void resolve(TranslationContext context) {
        left = left.resolve(context);
        right = right.resolve(context);
    }

    @Override
    public void accept(EquationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Equation replace(ReplaceContext context) {
        return new EqBasic(location, left.replace(context), right.replace(context));
    }
}
