package org.simantics.scl.compiler.elaboration.chr.relations;

import org.simantics.scl.compiler.elaboration.chr.CHRRelation;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public enum SpecialCHRRelation implements CHRRelation {    
    EQUALS(A, A),
    MEMBER(A, Types.list(A)),
    CHECK(Types.BOOLEAN),
    EXECUTE(Types.UNIT);
    
    private final TVar[] typeVariables;
    private final Type[] parameterTypes;
    
    private SpecialCHRRelation(Type ... parameterTypes) {
        this.typeVariables = Types.freeVarsArray(parameterTypes);
        this.parameterTypes = parameterTypes;
    }

    @Override
    public TVar[] getTypeVariables() {
        return typeVariables;
    }
    
    @Override
    public Type[] getParameterTypes() {
        return parameterTypes;
    }
    
    public TPred[] getTypeConstraints() {
        return TPred.EMPTY_ARRAY;
    }
}
