package org.simantics.scl.compiler.elaboration.chr.relations;

import java.util.ArrayList;
import java.util.Collection;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.JavaMethod;
import org.simantics.scl.compiler.constants.NoRepConstant;
import org.simantics.scl.compiler.constants.generic.CallJava;
import org.simantics.scl.compiler.constants.generic.MethodRef.ConstructorRef;
import org.simantics.scl.compiler.constants.generic.MethodRef.FieldRef;
import org.simantics.scl.compiler.constants.generic.MethodRef.ObjectMethodRef;
import org.simantics.scl.compiler.constants.generic.ParameterStackItem;
import org.simantics.scl.compiler.constants.generic.StackItem;
import org.simantics.scl.compiler.elaboration.chr.CHRRelation;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.plan.PrioritizedPlan;
import org.simantics.scl.compiler.internal.codegen.chr.CHRCodeGenerator;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

import gnu.trove.map.hash.TIntObjectHashMap;

public class CHRConstraint extends Symbol implements CHRRelation {
    public final String name;
    public final Type[] parameterTypes;
    
    public boolean implicitlyDeclared;

    // Analysis
    public int firstPriorityAdded;
    public int lastPriorityAdded;
    public int firstPriorityRemoved;
    public int lastPriorityRemoved;
    
    // Transient info
    public CHRRuleset parentRuleset;
    public String factClassName;
    public Type factType;
    public TypeDesc factTypeDesc;
    
    public TCon typeConstructor;
    public Constant constructor;
    public Constant accessId;
    public Constant[] accessors;
    public Constant addProcedure;
    public Constant removeProcedure;
    public Constant isAlive;
    
    public TIntObjectHashMap<IndexInfo> indices;
    
    // Query plans
    public ArrayList<PrioritizedPlan> plans = new ArrayList<PrioritizedPlan>();
    
    public static class IndexInfo {
        public final int indexMask;
        public final String indexName;
        public final Constant firstFact;
        public final Constant nextFact;
        
        public IndexInfo(int indexMask, String indexName, Constant firstFact, Constant nextFact) {
            this.indexMask = indexMask;
            this.indexName = indexName;
            this.firstFact = firstFact;
            this.nextFact = nextFact;
        }
    }
    
    public CHRConstraint(long location, String name, Type[] parameterTypes) {
        this.location = location;
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public void initializeCodeGeneration(CompilationContext context, CHRRuleset parentRuleset) {
        JavaTypeTranslator jtt = context.javaTypeTranslator;
        
        this.parentRuleset = parentRuleset;
        this.factClassName = parentRuleset.storeClassName + "$" + name;
        TCon factTypeConstructor = Types.con(parentRuleset.storeType.module, parentRuleset.storeType.name + "$" + name); 
        this.factType = Types.apply(factTypeConstructor, TVar.EMPTY_ARRAY);
        this.factTypeDesc = TypeDesc.forClass(factClassName);
        
        Type[] constructorTypes = new Type[parameterTypes.length+1];
        constructorTypes[0] = Types.INTEGER;
        ArrayList<StackItem> stackItems = new ArrayList<StackItem>(constructorTypes.length);
        stackItems.add(new ParameterStackItem(0, Types.INTEGER));
        for(int i=0;i<parameterTypes.length;++i) {
            Type parameterType = parameterTypes[i];
            constructorTypes[i+1] = parameterType;
            if(!parameterType.equals(Types.UNIT))
                stackItems.add(new ParameterStackItem(stackItems.size(), parameterType));
        }
        TypeDesc[] constructorTypeDescs = JavaTypeTranslator.filterVoid(jtt.toTypeDescs(constructorTypes));
        this.constructor = new CallJava(TVar.EMPTY_ARRAY, Types.PROC, factType, constructorTypes,
                stackItems.toArray(new StackItem[stackItems.size()]),
                new ConstructorRef(factClassName, constructorTypeDescs),
                null);
        //this.constructor = new JavaConstructor(factClassName, Types.PROC, factType, constructorTypes);
        this.accessId = new CallJava(TVar.EMPTY_ARRAY, Types.NO_EFFECTS, Types.INTEGER, new Type[] {factType},
                null, new FieldRef(factClassName, "id", CHRCodeGenerator.FACT_ID_TYPE), null);
        this.accessors = new Constant[parameterTypes.length];
        for(int i=0;i<parameterTypes.length;++i) {
            TypeDesc typeDesc = jtt.toTypeDesc(parameterTypes[i]);
            if(typeDesc.equals(TypeDesc.VOID))
                continue;
            this.accessors[i] = new CallJava(TVar.EMPTY_ARRAY, Types.NO_EFFECTS, parameterTypes[i], new Type[] {factType},
                    null, new FieldRef(factClassName, CHRCodeGenerator.fieldName(i), jtt.toTypeDesc(parameterTypes[i])), null);
        }
        this.addProcedure = new CallJava(TVar.EMPTY_ARRAY, Types.PROC, Types.UNIT, new Type[] {parentRuleset.storeType, factType},
                new StackItem[] {new ParameterStackItem(1, factType), new ParameterStackItem(0, parentRuleset.storeType)},
                new ObjectMethodRef(false, factClassName, "add", TypeDesc.VOID, new TypeDesc[] {parentRuleset.storeTypeDesc}),
                null);
        
        this.indices = new TIntObjectHashMap<IndexInfo>(Math.min(10, 1 << parameterTypes.length));
        
        if(context.module != null) // for unit testing
            context.module.addTypeDescriptor(factTypeConstructor.name, new StandardTypeConstructor(factTypeConstructor, TVar.EMPTY_ARRAY, factTypeDesc));
    }

    @Override
    public TVar[] getTypeVariables() {
        return TVar.EMPTY_ARRAY;
    }

    @Override
    public Type[] getParameterTypes() {
        return parameterTypes;
    }
    
    @Override
    public String toString() {
        return name;
    }
    
    public Collection<IndexInfo> getIndices() {
        return indices.valueCollection();
    }
    
    public boolean mayBeRemoved() {
        return removeProcedure != null;
    }

    private IndexInfo createIndexInfo(CompilationContext context, int indexMask) {
        ArrayList<Type> keyTypeList = new ArrayList<Type>(parameterTypes.length+1);
        keyTypeList.add(parentRuleset.storeType);
        for(int i=0;i<parameterTypes.length;++i)
            if(((indexMask>>i)&1)==1)
                keyTypeList.add(parameterTypes[i]);
        String indexName = nameOfIndex(indexMask, parameterTypes.length);
        Constant accessIndex;
        if(indexMask == 0) {
            accessIndex = new CallJava(TVar.EMPTY_ARRAY, Types.PROC, factType, new Type[] {parentRuleset.storeType},
                    null, new FieldRef(parentRuleset.storeClassName, name + "$" + indexName, factTypeDesc), null);
        }
        else {
            Type[] keyTypes = keyTypeList.toArray(new Type[keyTypeList.size()]);
            accessIndex = new JavaMethod(true, parentRuleset.storeClassName, name + "$" + indexName, Types.PROC, factType, keyTypes);
        }
        return new IndexInfo(
                indexMask,
                indexName,
                accessIndex,
                new CallJava(TVar.EMPTY_ARRAY, Types.PROC, factType, new Type[] {factType},
                        null, new FieldRef(factClassName, indexName + "Next", factTypeDesc), null)
                );
    }
    
    public IVal fetchFromIndex(CompilationContext context, int boundMask) {
        IndexInfo indexInfo = indices.get(boundMask);
        if(indexInfo == null) {
            indexInfo = createIndexInfo(context, boundMask);
            indices.put(boundMask, indexInfo);
        }
        return indexInfo.firstFact;
    }

    public Constant nextElement(CompilationContext context, int boundMask) {
        IndexInfo indexInfo = indices.get(boundMask);
        if(indexInfo == null) {
            indexInfo = createIndexInfo(context, boundMask);
            indices.put(boundMask, indexInfo);
        }
        return indexInfo.nextFact;
    }

    
    public static String nameOfIndex(int indexMask, int length) {
        char[] chars = new char[length];
        for(int i=0;i<length;++i)
            chars[i] = ((indexMask>>i)&1) == 1 ? 'b' : 'f';
        return new String(chars);
    }

    public void setMayBeRemoved() {
        if(removeProcedure == null) {
            removeProcedure = new CallJava(TVar.EMPTY_ARRAY, Types.PROC, Types.UNIT, new Type[] {parentRuleset.storeType, factType},
                    new StackItem[] {new ParameterStackItem(1, factType), new ParameterStackItem(0, parentRuleset.storeType)},
                    new ObjectMethodRef(false, factClassName, "remove", TypeDesc.VOID, new TypeDesc[] {parentRuleset.storeTypeDesc}),
                    null);
            isAlive = new JavaMethod(true, factClassName, "isAlive", Types.PROC, Types.BOOLEAN, factType);
        }
    }

    public int getMinimumPriority() {
        return plans.get(0).priority;
    }
    
    public boolean isPassive() {
        return plans.isEmpty();
    }

    public TPred[] getTypeConstraints() {
        return TPred.EMPTY_ARRAY;
    }

    public IVal accessComponent(long location, CodeWriter w, IVal fact, int i) {
        Constant accessor = accessors[i];
        if(accessor == null)
            return NoRepConstant.UNIT;
        else
            return w.apply(location, accessor, fact);
    }
}
