package org.simantics.scl.compiler.elaboration.chr;

import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.JavaConstructor;
import org.simantics.scl.compiler.internal.codegen.chr.CHRCodeGenerator;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAObject;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.types.Types;

public class CHRRulesetObject extends SSAObject {
    CHRRuleset ruleset;

    public CHRRulesetObject(BoundVar target, CHRRuleset ruleset) {
        super(ruleset.storeType);
        this.setTarget(target);
        this.ruleset = ruleset;
    }
    
    @Override
    public Constant liftClosure(BoundVar newTarget, BoundVar[] parameters) {
        ruleset.this_ = newTarget;
        ruleset.parameters = parameters;
        return new JavaConstructor(ruleset.storeClassName, Types.PROC, ruleset.storeType, Types.getTypes(parameters));
    }
    
    @Override
    public void generateCode(ModuleBuilder moduleBuilder) {
        CHRCodeGenerator.generateStore(moduleBuilder, ruleset);
    }
}
