package org.simantics.scl.compiler.elaboration.chr;

import org.simantics.scl.compiler.elaboration.chr.plan.PostCommitOp;
import org.simantics.scl.compiler.elaboration.chr.plan.PreCommitOp;
import org.simantics.scl.compiler.elaboration.chr.planning.QueryPlanningContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.expressions.printing.ExpressionToStringVisitor;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.parsing.Symbol;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public class CHRQuery extends Symbol {
    public CHRLiteral[] literals;

    public CHRQuery(CHRLiteral[] literals) {
        this.literals = literals;
    }

    public void resolve(TranslationContext context) {
        for(CHRLiteral literal : literals)
            literal.resolve(context);
    }

    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        for(CHRLiteral literal : literals)
            literal.collectRefs(allRefs, refs);
    }

    public void checkType(TypingContext context) {
        for(CHRLiteral literal : literals)
            literal.checkType(context);
    }
    
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        for(CHRLiteral literal : literals)
            literal.collectVars(allVars, vars);
    }

    public void forVariables(VariableProcedure procedure) {
        for(CHRLiteral literal : literals)
            literal.forVariables(procedure);
    }

    public void collectFreeVariables(THashSet<Variable> vars) {
        for(CHRLiteral literal : literals)
            literal.collectFreeVariables(vars);
    }

    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            this.location = loc;
            for(CHRLiteral literal : literals)
                literal.setLocationDeep(loc);
        }
    }
    
    public boolean createQueryPlan(QueryPlanningContext context, Expression inputFact, int activeLiteralId) {
        for(int i=0;i<literals.length;++i) {
            CHRLiteral literal = literals[i];
            if(i == activeLiteralId)
                context.activate(literal, inputFact, i);
            else
                context.add(literal, i);
        }
        return context.createQueryPlan();
    }
    
    public void simplify(SimplificationContext context) {
        for(CHRLiteral literal : literals)
            literal.simplify(context);
    }

    public void createEnforcePlan(QueryPlanningContext context, int priority) {
        context.addPlanOp(new PreCommitOp(location));
        for(CHRLiteral literal : literals)
            context.claim(context, literal);
        context.addPlanOp(new PostCommitOp(location, priority));
    }
    
    public String toString() {
        StringBuilder b = new StringBuilder();
        ExpressionToStringVisitor visitor = new ExpressionToStringVisitor(b);
        visitor.visit(this);
        return b.toString();
    }
}
