package org.simantics.scl.compiler.constants;

import java.util.Arrays;

import org.simantics.scl.compiler.elaboration.modules.MethodImplementation;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeClassMethod;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class JavaTypeClassMethod extends JavaMethod {

    TypeClassMethod method;
    
    public JavaTypeClassMethod(TypeClassMethod method, String className, String methodName,
            Type effect, Type returnType, Type[] parameterTypes) {
        super(false, className, methodName, effect, returnType, parameterTypes);
        this.method = method;
    }

    public TypeClassMethod getMethod() {
        return method;
    }
    
    public void inline(SSASimplificationContext context, LetApply apply) {
        //ValRef evidenceRef = apply.getParameters()[0];
        //inline(context, apply, evidenceRef.getBinding(), evidenceRef.getTypeParameters());
        
        ValRef classRef = apply.getParameters()[0];
        Val class_ = classRef.getBinding();
        if(class_ instanceof JavaTypeInstanceConstructor) {
            JavaTypeInstanceConstructor constr = (JavaTypeInstanceConstructor)class_;
            TypeClassInstance instance = constr.getInstance();
            MethodImplementation impl = 
                    instance.methodImplementations.get(method.getName());
            if(!impl.isDefault) {
                apply.getParameters()[0].remove();
                apply.setParameters(Arrays.copyOfRange(apply.getParameters(), 1, apply.getParameters().length));
                ValRef oldFunction = apply.getFunction();
                Type[] typeParameters = oldFunction.getTypeParameters();
                
                IVal newValue = context.getEnvironment().getValue(impl.name).getValue();
                
                typeParameters = Arrays.copyOfRange(typeParameters, 
                        instance.typeClass.parameters.length,
                        typeParameters.length);
                typeParameters = Types.concat(classRef.getTypeParameters(), typeParameters);                
                apply.setFunction(newValue.createOccurrence(typeParameters));
                oldFunction.remove();
                context.markModified("simplify-method");
            }
        }
    }
    
    /*private void inline(SSASimplificationContext context, LetApply apply, Val evidence, Type[] typeParameters) {
        if(evidence instanceof JavaTypeInstanceConstructor) {
            JavaTypeInstanceConstructor evidence_ = (JavaTypeInstanceConstructor)evidence;
            evidence_.
        }
        else if(evidence instanceof BoundVar) {
            BoundVarBinder parent = ((BoundVar)evidence).parent;
            if(!(parent instanceof LetApply))
                return;
            LetApply parentApply = (LetApply)apply;
        }
                
    }*/
    
}
