package org.simantics.scl.compiler.common.exceptions;

import org.simantics.scl.compiler.errors.Locations;

public class InternalCompilerError extends RuntimeException {

    private static final long serialVersionUID = -912160242899559098L;
    public long location;
    
    public InternalCompilerError() {
        super();
        this.location = Locations.NO_LOCATION;
    }
    
    public InternalCompilerError(long location) {
        super();
        this.location = location;
    }

    public InternalCompilerError(String message) {
        super(message);
        this.location = Locations.NO_LOCATION;
    }
    
    public InternalCompilerError(long location, String message) {
        super(message);
        this.location = location;
    }

    public InternalCompilerError(Throwable cause) {
        super(cause);
        this.location = Locations.NO_LOCATION;
    }
   
}
