package org.simantics.scl.commands.internal.serialization;

import org.simantics.db.Resource;
import org.simantics.scl.commands.internal.StringConverterFactory;
import org.simantics.scl.compiler.errors.CompilationErrorFormatter;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function2;

public class CommandSerializerFactory {
    @SuppressWarnings("unchecked")
    public static CommandSerializer create(String name, Type[] parameterTypes) {
        Function2<Resource,Object,String>[] stringConverters = new Function[parameterTypes.length];
        for(int i=0;i<parameterTypes.length;++i) {
            try {
                stringConverters[i] = StringConverterFactory.stringConverterFor(parameterTypes[i]);
            } catch(SCLExpressionCompilationException e) {
                System.err.println("Failed to create a string converter for type " + parameterTypes[i] + ".");
                System.err.println(CompilationErrorFormatter.toString(e.getErrors()));
                return new ErrorSerializer(name);
            } catch (ImportFailureException e) {
                System.err.println("Failed to create a string converter for type " + parameterTypes[i] + ".");
                System.err.println("Didn't find Simantics/GShow/gshow.");
                return new ErrorSerializer(name);
            }
        }
        return new CommandSerializerImpl(name, stringConverters);
    }
}
