package org.simantics.scl.commands.internal.checker;

import java.util.Map;

import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.MultiFunction;
import org.simantics.scl.osgi.SCLOsgi;

/**
 * Checks given parameters
 * 
 * @author Hannu Niemist&ouml;
 */
public class Checker {
    Object check;
    CheckItem item;
    
    private Checker(Object check, CheckItem item) {
        this.check = check;
        this.item = item;
    }
    
    public boolean check(Object[] parameters) {
        return item.check(check, parameters, 0);
    }

    private static CheckItem checkItemForType(Type type) throws MatchException {
        if(type == Types.BOOLEAN)
            return BooleanCheckItem.INSTANCE;
        if(Types.isFunction(type)) {
            MultiFunction mfun = Types.matchFunction(type, 1);
            return new FunctionCheckItem(mfun.parameterTypes[0], checkItemForType(mfun.returnType));
        }
        else if(Types.isApply(Types.MAYBE, 1, type)) {
            Type componentType = Types.matchApply(Types.MAYBE, type);
            return new MaybeCheckItem(checkItemForType(componentType));
        }
        else
            throw new MatchException();
    }
    
    public static Checker create(String name) {
        try {
            SCLValue checkRef = SCLOsgi.MODULE_REPOSITORY.getValueRef(name);
            Object check = SCLOsgi.MODULE_REPOSITORY.getValue(name);
            return new Checker(check, checkItemForType(checkRef.getType()));
        } catch(ValueNotFound e) {
            // If we don't find a check, it always succeeds
            return new Checker(Boolean.TRUE, BooleanCheckItem.INSTANCE);
        } catch (MatchException e) {
            // Should not happens
            e.printStackTrace();
            return new Checker(Boolean.FALSE, BooleanCheckItem.INSTANCE);
        }
    }
}
