/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.EdgeNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.scenegraph.utils.InitValueSupport;
import org.simantics.scenegraph.utils.NodeUtil;

public class ConnectionNode
extends SingleElementNode
implements InitValueSupport {
    private static final long serialVersionUID = 8657421058765967521L;
    private static final SetAlphaCompositeProcedure setAlphaCompositeProcedure = new SetAlphaCompositeProcedure();
    private static final SetDynamicStrokeProcedure setDynamicStrokeProcedure = new SetDynamicStrokeProcedure();
    private static final SetDynamicColorProcedure setDynamicColorProcedure = new SetDynamicColorProcedure();
    private static NodeUtil.NodeProcedure<?> initValuesProcedure = new NodeUtil.NodeProcedure<Object>(){

        @Override
        public Object execute(INode node, String id) {
            if (node instanceof InitValueSupport) {
                ((InitValueSupport)((Object)node)).initValues();
            }
            return null;
        }
    };

    @Override
    @INode.PropertySetter(value="alpha")
    public void setAlphaComposite(Composite alphaComposite) {
        ConnectionNode.setAlphaCompositeProcedure.composite = alphaComposite;
        this.forEdges(this, setAlphaCompositeProcedure);
    }

    @INode.PropertySetter(value="width")
    public void setDynamicStroke(Stroke stroke) {
        ConnectionNode.setDynamicStrokeProcedure.stroke = stroke;
        this.forEdges(this, setDynamicStrokeProcedure);
    }

    @INode.PropertySetter(value="color")
    public void setDynamicColor(Color color) {
        ConnectionNode.setDynamicColorProcedure.color = color;
        this.forEdges(this, setDynamicColorProcedure);
    }

    @Override
    public void initValues() {
        NodeUtil.forChildren(this, initValuesProcedure, null);
    }

    private void forEdges(SingleElementNode node, NodeUtil.NodeProcedure<?> procedure) {
        String[] stringArray = node.getSortedNodesById();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String childId = stringArray[n2];
            IG2DNode child = (IG2DNode)node.getNode(childId);
            if (child instanceof SingleElementNode) {
                this.forEdges((SingleElementNode)child, procedure);
            } else if (child instanceof EdgeNode) {
                procedure.execute(child, childId);
            } else if (child instanceof RouteGraphNode) {
                procedure.execute(child, childId);
            }
            ++n2;
        }
    }

    @Override
    protected boolean hitTest(MouseEvent event) {
        if (!super.hitTest(event)) {
            return false;
        }
        Point2D pos = NodeUtil.worldToLocal(this, event.controlPosition, new Point2D.Double());
        double tolerance = 0.5;
        IG2DNode[] iG2DNodeArray = this.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RouteGraphNode rgn;
            RouteGraph rg;
            RouteLine pick;
            IG2DNode child = iG2DNodeArray[n2];
            if (child instanceof RouteGraphNode && (pick = (rg = (rgn = (RouteGraphNode)child).getRouteGraph()).pickLine(pos.getX(), pos.getY(), tolerance)) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static class SetAlphaCompositeProcedure
    implements NodeUtil.NodeProcedure<Object> {
        public Composite composite;

        private SetAlphaCompositeProcedure() {
        }

        @Override
        public Object execute(INode node, String id) {
            if (node instanceof EdgeNode) {
                ((EdgeNode)node).setAlphaComposite(this.composite);
            }
            return null;
        }
    }

    private static class SetDynamicColorProcedure
    implements NodeUtil.NodeProcedure<Object> {
        public Color color;

        private SetDynamicColorProcedure() {
        }

        @Override
        public Object execute(INode node, String id) {
            if (node instanceof EdgeNode) {
                ((EdgeNode)node).setDynamicColor(this.color);
            } else if (node instanceof RouteGraphNode) {
                ((RouteGraphNode)node).setDynamicColor(this.color);
            }
            return null;
        }
    }

    private static class SetDynamicStrokeProcedure
    implements NodeUtil.NodeProcedure<Object> {
        public Stroke stroke;

        private SetDynamicStrokeProcedure() {
        }

        @Override
        public Object execute(INode node, String id) {
            if (node instanceof EdgeNode) {
                ((EdgeNode)node).setDynamicStroke(this.stroke);
            } else if (node instanceof RouteGraphNode) {
                ((RouteGraphNode)node).setDynamicStroke(this.stroke);
            }
            return null;
        }
    }
}

