/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simantics.scenegraph.ILookupService;
import org.simantics.scenegraph.INode;

public class LookupService
implements ILookupService {
    private final Object lookupLock = new Object();
    private final Map<String, INode> toNode = new HashMap<String, INode>();
    private final Map<INode, String> toId = new HashMap<INode, String>();
    Logger logger = Logger.getLogger(this.getClass().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INode map(String id, INode node) {
        String oldId;
        INode oldNode;
        if (id == null) {
            throw new NullPointerException("null id");
        }
        if (node == null) {
            throw new NullPointerException("null node");
        }
        Object object = this.lookupLock;
        synchronized (object) {
            INode removedNode;
            String removedId;
            oldNode = this.toNode.put(id, node);
            oldId = this.toId.put(node, id);
            if (oldNode != null && !oldNode.equals(node) && !id.equals(removedId = this.toId.remove(oldNode))) {
                this.toNode.remove(removedId);
            }
            if (oldId != null && !oldId.equals(id) && (removedNode = this.toNode.remove(oldId)) != node) {
                this.toId.remove(removedNode);
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("map(" + id + ", " + node + ")");
        }
        if ((oldNode != null || oldId != null) && this.logger.isLoggable(Level.INFO)) {
            this.logger.info("replaced mappings for ID " + oldId + " and node " + oldNode);
        }
        return oldNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INode unmap(String id) {
        String mappedId;
        INode node;
        Object object = this.lookupLock;
        synchronized (object) {
            block6: {
                node = this.toNode.remove(id);
                if (node != null) break block6;
                return null;
            }
            mappedId = this.toId.remove(node);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("unmap(" + id + "): " + node);
        }
        if (mappedId != null && !mappedId.equals(id) && this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, "mapping was out-of-sync: " + id + " => " + node + " & " + mappedId + " => " + node, new Exception("trace"));
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String unmap(INode node) {
        INode mappedNode;
        String id;
        Object object = this.lookupLock;
        synchronized (object) {
            block6: {
                id = this.toId.remove(node);
                if (node != null) break block6;
                return null;
            }
            mappedNode = this.toNode.remove(id);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("unmap(" + node + "): " + id);
        }
        if (mappedNode != null && node != mappedNode && this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, "mapping was out-of-sync: " + node + " => " + id + " & " + id + " => " + mappedNode, new Exception("trace"));
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INode lookupNode(String id) {
        Object object = this.lookupLock;
        synchronized (object) {
            return this.toNode.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupId(INode node) {
        Object object = this.lookupLock;
        synchronized (object) {
            return this.toId.get(node);
        }
    }
}

