/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.ui;

import java.lang.ref.WeakReference;

import org.simantics.scenegraph.INode;

/**
 * @author Tuukka Lehtonen
 */
class NodeProxy {

    WeakReference<INode> ref;
    String               id;

    NodeProxy(INode n) {
        this(n, null);
    }

    NodeProxy(INode n, String id) {
        this.ref = new WeakReference<INode>(n);
        this.id = id;
    }

    INode getNode() {
        return ref.get();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        INode n = getNode();
        if (id != null) {
            sb.append("[");
            sb.append(id);
            sb.append("] ");
        }
        if (n == null) {
            sb.append("(collected)");
        } else {
            sb.append(n.getSimpleClassName());
        }
        return sb.toString();
    }

    public String getTypeName() {
        INode n = getNode();
        return n == null ? "-" : n.getSimpleClassName();
    }

    public String getInternalId() {
        INode n = getNode();
        if (n == null)
            return "-";
        return n.getId().toString();
    }

    public String getId() {
        return id;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((id == null) ? 0 : id.hashCode());
        INode node = getNode();
        result = prime * result + ((node == null) ? 0 : node.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        NodeProxy other = (NodeProxy) obj;
        if (id == null) {
            if (other.id != null)
                return false;
        } else if (!id.equals(other.id))
            return false;

        INode node = getNode();
        INode otherNode = other.getNode();
        if (node == null || otherNode == null)
            // Collected nodes are never equal to any other node
            return false;

        return node.equals(otherNode);
    }

}