/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.example;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JSlider;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.AnimatedSVGNode;
import org.simantics.scenegraph.g2d.nodes.GridNode;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.g2d.nodes.RulerNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.g2d.nodes.TransformNode;
import org.simantics.scenegraph.g2d.nodes.Trend2DNode;
import org.simantics.scenegraph.swing.ButtonNode;
import org.simantics.scenegraph.swing.LabelNode;
import org.simantics.scenegraph.swing.MonitorNode;
import org.simantics.scenegraph.swing.SliderNode;

public class SampleThread implements Runnable {

	public G2DSceneGraph sg = new G2DSceneGraph();
	protected TransformNode transform = null;
	protected TransformNode transform2 = null;
	
	protected boolean interrupted = false;
	
	public void start() {
		interrupted = false;
		Thread t = new Thread(this);
		t.start();
	}
	
	public void stop() {
		interrupted = true;
	}
	
	protected void close() {
	}

	protected boolean init() {
		return true;
	}
	
	protected boolean rotate = true;
	protected float t1 = 0;
	protected float t2 = 0;
	
	private String loadSVG(String filename) throws IOException {
		String data = "";
		BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));

		while(reader.ready()) {
			data += reader.readLine();
		}

		reader.close();
		return data;
	}
	
	public void run() {
		if(!init()) return;

		final NavigationNode nav = sg.addNode(NavigationNode.class);
		GridNode grid = nav.addNode(GridNode.class);
		grid.setZIndex(1);
		
//		AnimatedSVGNode bmw = null;
		AnimatedSVGNode svg1 = null;
		AnimatedSVGNode svg2 = null;
		AnimatedSVGNode svg3 = null;
		AnimatedSVGNode svg4 = null;
		try {
			String data = loadSVG("tynnyri.svg");
			svg1 = nav.addNode(AnimatedSVGNode.class);
			svg1.setZIndex(20);
			svg1.setData(data);
			svg1.setTransform(AffineTransform.getTranslateInstance(0, 150));
			svg1.useMipMap(false);
			
			svg2 = nav.addNode(AnimatedSVGNode.class);
			svg2.setZIndex(20);
			svg2.setData(data);
			svg2.setTransform(AffineTransform.getTranslateInstance(250, 150));
			svg2.useMipMap(false);
			
			svg3 = nav.addNode(AnimatedSVGNode.class);
			svg3.setZIndex(20);
			svg3.setData(data);
			svg3.setTransform(AffineTransform.getTranslateInstance(500, 150));
			svg3.useMipMap(false);
			
			svg4 = nav.addNode(AnimatedSVGNode.class);
			svg4.setZIndex(20);
			svg4.setData(data);
			svg4.setTransform(AffineTransform.getTranslateInstance(750, 150));
			svg4.useMipMap(false);
		} catch(IOException e) {
			e.printStackTrace();
		}

//		try {
//			bmw = nav.addNode(AnimatedSVGNode.class);
//			bmw.setZIndex(50);
//			bmw.setData(loadSVG("D:\\bemari.svg"));
//			bmw.setPosition(100, 100);
////			bmw.setTargetSize(50, 50);
//			bmw.useMipMap(false);
//			
//			String init = "if(rotate === undefined || y === undefined || x === undefined) { var rotate = 0; var y = 0; var x = 0; }";
//			String left = "rotate = (rotate - 10)%360;";
//			String right = "rotate = (rotate + 10)%360;";
//			String up = "x -= (Math.cos(rotate*3.14/180))*20; y -= (Math.sin(rotate*3.14/180))*20; ";
//			String down = "x += (Math.cos(rotate*3.14/180))*20; y += (Math.sin(rotate*3.14/180))*20; ";
//			
//			String base = 
//				"t.setValue(\"rotate\", rotate); "+
//				"t.setValue(\"x\", x); "+
//				"t.setValue(\"y\", y); "+
//				"var m = new Array(6); "+
//				"m[0] = Math.cos(rotate*3.14/180); "+
//				"m[2] = -Math.sin(rotate*3.14/180); "+
//				"m[4] = x; "+
//				
//				"m[1] = Math.sin(rotate*3.14/180); "+
//				"m[3] = Math.cos(rotate*3.14/180); "+
//				"m[5] = y; "+
//				"if(svg.getRoot().hasAttribute(\"transform\", 1)) {"+
//				"    svg.getRoot().setAttribute(\"transform\", 1, \"matrix(\"+m.join(\",\")+\")\");"+
//				"} else {"+
//				"	svg.getRoot().addAttribute(\"transform\", 1, \"matrix(\"+m.join(\",\")+\")\");"+
//				"}";
//			bmw.registerEventAnimation("LEFT", init+left+base);
//			bmw.registerEventAnimation("RIGHT", init+right+base);
//			bmw.registerEventAnimation("UP", init+up+base);
//			bmw.registerEventAnimation("DOWN", init+down+base);
//		} catch(IOException e) {
//			e.printStackTrace();
//		}
//		
		transform = nav.addNode(TransformNode.class);
		transform.setZIndex(3);
		AffineTransform at = new AffineTransform();
		at.translate(200, 200);
		transform.setTransform(at);
		ShapeNode box = transform.addNode(ShapeNode.class);
		box.setZIndex(1);
		box.setShape(new Rectangle2D.Double(-50, -50, 100, 100));

		MonitorNode cn = nav.addNode(MonitorNode.class);
		cn.setZIndex(2);
		cn.setTransform(AffineTransform.getTranslateInstance(100, 50));
		cn.setBounds(new Rectangle2D.Double(0, 0, 100, 25));

		final ButtonNode button = nav.addNode(ButtonNode.class);
		button.setZIndex(3);
		button.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if(rotate) {
					button.setText("Start rotation");
					rotate = false;
				} else {
					button.setText("Stop rotation");
					rotate = true;
				}
			}});
		button.setText("Stop rotation");
		button.setBounds(new Rectangle2D.Double(0, 0, 100, 20));
		button.setTransform(AffineTransform.getTranslateInstance(100, 75));

	    SliderNode sn1 = nav.addNode(SliderNode.class);
	    sn1.setZIndex(4);
		sn1.setTransform(AffineTransform.getTranslateInstance(100, 100));
		sn1.setBounds(new Rectangle2D.Double(0, 0, 150, 50));
		
		sn1.setTitle("Rotation speed 1");
		sn1.setMaximum(100);
		sn1.setValue(20);
		sn1.setMajorTickSpacing(20);
		sn1.setMinorTickSpacing(5);
		sn1.setPaintTicks(true);

		
	    JSlider slider2 = new JSlider();
	    slider2.setBorder(BorderFactory.createTitledBorder("Rotation speed 2"));
	    slider2.setMaximum(100);
	    slider2.setValue(50);
	    slider2.setMajorTickSpacing(20);
	    slider2.setMinorTickSpacing(5);
	    slider2.setPaintTicks(true);
	    SliderNode sn2 = nav.addNode(SliderNode.class);
	    sn2.setZIndex(5);
//	    sn2.setComponent(slider2);
		sn2.setTransform(AffineTransform.getTranslateInstance(250, 100));
		sn2.setBounds(new Rectangle2D.Double(0, 0, 150, 50));
		
		LabelNode cn2 = nav.addNode(LabelNode.class);
		cn2.setZIndex(6);
		cn2.setText("Name");
		cn2.setBounds(new Rectangle2D.Double(0, 0, 100, 25));
		cn2.setTransform(AffineTransform.getTranslateInstance(100, 30));

		MonitorNode cn3 = nav.addNode(MonitorNode.class);
		cn3.setZIndex(7);
		cn3.setTransform(AffineTransform.getTranslateInstance(250, 50));
		cn3.setBounds(new Rectangle2D.Double(0, 0, 100, 25));
		
		LabelNode cn4 = nav.addNode(LabelNode.class);
		cn4.setZIndex(8);
		cn4.setText("Phone number");
		cn4.setTransform(AffineTransform.getTranslateInstance(250, 30));
		cn4.setBounds(new Rectangle2D.Double(0, 0, 100, 25));
		
		transform2 = transform.addNode(TransformNode.class);
		transform2.setZIndex(9);
		
		ShapeNode box2 = transform2.addNode(ShapeNode.class);
		box2.setShape(new Rectangle2D.Double(-30, -30, 60, 60));

		Trend2DNode trend = nav.addNode(Trend2DNode.class);
		trend.setZIndex(10);
		trend.setBounds(new Rectangle2D.Double(0, 0, 200, 200));
		trend.setPosition(400, 200);
		List<Trend2DNode.TrendPoint> points = new ArrayList<Trend2DNode.TrendPoint>();
		int p = 0;
		for(p = 0; p < 20;) {
			points.add(new Trend2DNode.TrendPoint(p++, Math.random()));
		}
		trend.updatePoints(points);
		
		RulerNode ruler = nav.addNode(RulerNode.class);
		ruler.setZIndex(11);

//    	String script =
//    		"if(level === undefined) {\n"+
//    		"	var level = (time/10)%200;\n"+
//			"   if(level > 100) level = 200 - level;\n"+
//    		"}\n"+
//    		"var y = 620;\n"+
//    		"var height = 285*level/100;\n"+
//    		"svg.getElement(\"fill\").setAttribute(\"y\", 1, y-height);\n"+
//    		"svg.getElement(\"fill\").setAttribute(\"height\", 1, height);\n"+
//    		"svg.getElement(\"upperlevel\").setAttribute(\"transform\", 1, \"translate(1.4285587, \"+(280-height)+\")\");\n";

    	String script1 =
    		"var y = 620;\n"+
    		"var height = 285*level/100;\n"+
    		"var r = (2*level).toString(16); var b = (2*(100-level)).toString(16);\n"+
    		"var color = \"#\"+(r.length == 1 ? \"0\"+r : r)+\"00\"+(b.length == 1 ? \"0\"+b : b);\n"+
    		"svg.getElement(\"fill\").setAttribute(\"fill\", 0, color)\n"+
    		"svg.getElement(\"upperlevel\").setAttribute(\"fill\", 0, color)\n"+
    		"svg.getElement(\"bottom\").setAttribute(\"fill\", 0, color)\n"+
    		"svg.getElement(\"fill\").setAttribute(\"y\", 1, y-height);\n"+
    		"svg.getElement(\"fill\").setAttribute(\"height\", 1, height);\n"+
    		"svg.getElement(\"upperlevel\").setAttribute(\"transform\", 1, \"translate(1.4285587, \"+(280-height)+\")\");\n";

    	String script2 =
    		"var level = (time/10)%200;\n"+
			"if(level > 100) level = 200 - level;\n"+
    		"var y = 620;\n"+
    		"var height = 285*level/100;\n"+
    		"svg.getElement(\"fill\").setAttribute(\"y\", 1, y-height);\n"+
    		"svg.getElement(\"fill\").setAttribute(\"height\", 1, height);\n"+
    		"svg.getElement(\"upperlevel\").setAttribute(\"transform\", 1, \"translate(1.4285587, \"+(280-height)+\")\");\n";
    	
    	sn1.setActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				Integer v = Integer.parseInt(e.getActionCommand());
				t1 = (float)v/1000;
			}});
    	sn2.setActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				Integer v = Integer.parseInt(e.getActionCommand());
				t2 = (float)v/1000;
			}});
    	
		svg1.setScript(script1);
		svg2.setScript(script1);

		while(!interrupted) {
			if(rotate) {
				transform.rotate(t1);
				transform2.rotate(t2);
				
				points.add(new Trend2DNode.TrendPoint(p++, Math.random()));
				trend.updatePoints(points);
			}
			svg1.setValue("level", new Double(t1*1000));
			svg2.setValue("level", new Double(t2*1000));
			
			svg3.animate(script2);
			svg4.animate(script2);

			repaint();
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		close();
	}
	
	public void repaint() {
		
	}

}
