/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.management;

import java.util.regex.Matcher;

/**
 * Graph bundle reference in graph.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class GraphBundleRef {

	public static GraphBundleRef of(String versionedId) {
		Matcher m = GraphBundle.VERSIONED_ID_PATTERN.matcher(versionedId);
		String id = m.group(1);
		int major = Integer.valueOf( m.group(2) );
		return new GraphBundleRef(id, major);
	}
	
	public static GraphBundleRef of(GraphBundle bundle) {
		return new GraphBundleRef(bundle.getId(), bundle.getMajor());
	}
	
	public final String id;
	public final int major;
	
	public GraphBundleRef(String id, int major) {
		if (id==null) throw new IllegalArgumentException();
		this.id = id;
		this.major = major;
	}
	
	@Override
	public int hashCode() {
		return id.hashCode() + major;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof GraphBundleRef == false) return false;
		GraphBundleRef other = (GraphBundleRef) obj;
		return other.id.equals(id) && other.major == major;
	}
	
	@Override
	public String toString() {
		return id+"/"+major;
	}
	
}

