package org.simantics.nativemem.internal;

import java.util.Arrays;
import java.util.List;

import org.simantics.nativemem.ProcessMemoryCounters;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinNT.HANDLE;
import com.sun.jna.win32.StdCallLibrary;

public interface Psapi32 extends StdCallLibrary {

    Psapi32 INSTANCE = (Psapi32) Native.loadLibrary("Psapi", Psapi32.class);

    /*
     * https://msdn.microsoft.com/en-us/library/windows/desktop/ms684874%28v=vs.85%29.aspx
     */
    public static class PROCESS_MEMORY_COUNTERS_EX extends Structure {
        public int cb;
        public int PageFaultCount;
        public int PeakWorkingSetSize;
        public int WorkingSetSize;
        public int QuotaPeakPagedPoolUsage;
        public int QuotaPagedPoolUsage;
        public int QuotaPeakNonPagedPoolUsage;
        public int QuotaNonPagedPoolUsage;
        public int PagefileUsage;
        public int PeakPagefileUsage;
        public int PrivateUsage;

        @SuppressWarnings("rawtypes")
        @Override
        protected List getFieldOrder() {
            return PROCESS_MEMORY_COUNTERS_EX_FIELDS;
        }

        static final List<String> PROCESS_MEMORY_COUNTERS_EX_FIELDS = Arrays.asList(new String[] { 
                "cb", "PageFaultCount",
                "PeakWorkingSetSize", "WorkingSetSize",
                "QuotaPeakPagedPoolUsage", "QuotaPagedPoolUsage",
                "QuotaPeakNonPagedPoolUsage", "QuotaNonPagedPoolUsage",
                "PagefileUsage", "PeakPagefileUsage", "PrivateUsage"
        });

        public void writeTo(ProcessMemoryCounters to) {
            to.PageFaultCount = PageFaultCount;
            to.PeakWorkingSetSize = PeakWorkingSetSize;
            to.WorkingSetSize = WorkingSetSize;
            to.QuotaPeakPagedPoolUsage = QuotaPeakPagedPoolUsage;
            to.QuotaPagedPoolUsage = QuotaPagedPoolUsage;
            to.QuotaPeakNonPagedPoolUsage = QuotaPeakNonPagedPoolUsage;
            to.QuotaNonPagedPoolUsage = QuotaNonPagedPoolUsage;
            to.PagefileUsage = PagefileUsage;
            to.PeakPagefileUsage = PeakPagefileUsage;
            to.PrivateUsage = PrivateUsage;
        }
    }

    /*
     * https://msdn.microsoft.com/en-us/library/windows/desktop/ms683219%28v=vs.85%29.aspx
     */
    boolean GetProcessMemoryInfo(HANDLE Process, PROCESS_MEMORY_COUNTERS_EX ppsmemCounters, int cb);


}