package org.simantics.nativemem.internal;

public enum OS {
    APPLE, LINUX, SUN, WINDOWS, UNKNOWN;

    public static OS calculate() {
        String osName = System.getProperty("os.name");
        assert osName != null;
        osName = osName.toLowerCase();
        if (osName.startsWith("mac os x"))
            return APPLE;
        if (osName.startsWith("windows"))
            return WINDOWS;
        if (osName.startsWith("linux"))
            return LINUX;
        if (osName.startsWith("sun"))
            return SUN;
        return UNKNOWN;
    }
}
