package org.simantics.nativemem.internal;

/**
 * @author Tuukka Lehtonen
 */
public enum Arch {
    PPC, PPC_64, SPARC, X86, X86_64, UNKNOWN;

    public static Arch calculate() {
        String osArch = System.getProperty("os.arch");
        assert osArch != null;
        osArch = osArch.toLowerCase();
        if (osArch.equals("i386") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("x86"))
            return X86;
        if (osArch.startsWith("amd64") || osArch.startsWith("x86_64"))
            return X86_64;
        if (osArch.equals("ppc"))
            return PPC;
        if (osArch.startsWith("ppc"))
            return PPC_64;
        if (osArch.startsWith("sparc"))
            return SPARC;
        return UNKNOWN;
    }
}
