package org.simantics.nativemem;

/**
 * Architecture-independent version of the Windows PsApi PROCESS_MEMORY_COUNTERS
 * structure.
 * 
 * @author Tuukka Lehtonen
 */
public class ProcessMemoryCounters {
    public int PageFaultCount;
    public long PeakWorkingSetSize;
    public long WorkingSetSize;
    public long QuotaPeakPagedPoolUsage;
    public long QuotaPagedPoolUsage;
    public long QuotaPeakNonPagedPoolUsage;
    public long QuotaNonPagedPoolUsage;
    public long PagefileUsage;
    public long PeakPagefileUsage;
    public long PrivateUsage;

    @Override
    public String toString() {
        return "ProcessMemoryCounters [PageFaultCount="
                + PageFaultCount + ", PeakWorkingSetSize=" + PeakWorkingSetSize
                + ", WorkingSetSize=" + WorkingSetSize
                + ", QuotaPeakPagedPoolUsage=" + QuotaPeakPagedPoolUsage
                + ", QuotaPagedPoolUsage=" + QuotaPagedPoolUsage
                + ", QuotaPeakNonPagedPoolUsage=" + QuotaPeakNonPagedPoolUsage
                + ", QuotaNonPagedPoolUsage=" + QuotaNonPagedPoolUsage
                + ", PagefileUsage=" + PagefileUsage + ", PeakPagefileUsage="
                + PeakPagefileUsage + ", PrivateUsage=" + PrivateUsage + "]";
    }

    public String toHumanReadableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProcessMemoryCounters [\n\tPageFaultCount             = ").append(PageFaultCount)
        .append(",\n\tPeakWorkingSetSize         = ").append(toMb(PeakWorkingSetSize))
        .append(" MB,\n\tWorkingSetSize             = ").append(toMb(WorkingSetSize))
        .append(" MB,\n\tQuotaPeakPagedPoolUsage    = ").append(toMb(QuotaPeakPagedPoolUsage))
        .append(" MB,\n\tQuotaPagedPoolUsage        = ").append(toMb(QuotaPagedPoolUsage))
        .append(" MB,\n\tQuotaPeakNonPagedPoolUsage = ").append(toMb(QuotaPeakNonPagedPoolUsage))
        .append(" MB,\n\tQuotaNonPagedPoolUsage     = ").append(toMb(QuotaNonPagedPoolUsage))
        .append(" MB,\n\tPagefileUsage              = ").append(toMb(PagefileUsage))
        .append(" MB,\n\tPeakPagefileUsage          = ").append(toMb(PeakPagefileUsage))
        .append(" MB,\n\tPrivateUsage               = ").append(toMb(PrivateUsage))
        .append(" MB]");
        return sb.toString();
    }

    private double toMb(long bytes) {
        return (double) bytes / 1048576.0;
    }

}