package org.simantics.nativemem;

import org.simantics.nativemem.internal.Arch;
import org.simantics.nativemem.internal.OS;
import org.simantics.nativemem.internal.Psapi32;
import org.simantics.nativemem.internal.Psapi64;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT.HANDLE;


public class NativeMem {

    /**
     * @param out
     *            the structure to write the result into or <code>null</code> to
     *            create a new structure
     * @return the result structure
     */
    public static ProcessMemoryCounters getMemoryCounters(ProcessMemoryCounters out) {
        if (out == null)
            out = new ProcessMemoryCounters();

        OS os = OS.calculate();
        Arch arch = Arch.calculate();
        switch (os) {
        case WINDOWS: {
            HANDLE proc = Kernel32.INSTANCE.GetCurrentProcess();
            switch (arch) {
            case X86: {
                Psapi32.PROCESS_MEMORY_COUNTERS_EX pmem = new Psapi32.PROCESS_MEMORY_COUNTERS_EX();
                boolean ok = Psapi32.INSTANCE.GetProcessMemoryInfo(proc, pmem, pmem.size());
                if (ok)
                    pmem.writeTo(out);
                return out;
            }

            case X86_64: {
                Psapi64.PROCESS_MEMORY_COUNTERS_EX pmem = new Psapi64.PROCESS_MEMORY_COUNTERS_EX();
                boolean ok = Psapi64.INSTANCE.GetProcessMemoryInfo(proc, pmem, pmem.size());
                if (ok)
                    pmem.writeTo(out);
                return out;
            }

            default:
                throw new UnsupportedOperationException("Architecture " + arch + " not supported on operating system " + os);
            }
        }

        default:
            throw new UnsupportedOperationException("Operating system " + os + " not supported");
        }
    }

}