/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.model;

import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.browsing.ui.common.node.IDeletable;
import org.simantics.browsing.ui.common.node.IDropTargetNode;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.modeling.PropertyVariables;
import org.simantics.modeling.subscription.AddSubscriptionItems;
import org.simantics.modeling.utils.VariableReferences;
import org.simantics.structural.ui.modelBrowser.nodes.AbstractNode;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class SubscriptionNode extends AbstractNode implements IDeletable, IDropTargetNode {

    public SubscriptionNode(Resource resource) {
        super(resource);
    }

    @Override
    public void drop(Object data) {
        if (!(data instanceof ISelection))
            return;
        final List<PropertyVariables> vars = ISelectionUtils.filterSelection((ISelection) data, PropertyVariables.class);
        if (!vars.isEmpty()) {
            List<VariableReference> references;
            try {
                references = SimanticsUI.getSession().syncRequest(VariableReferences.toReferences(vars));
                addSubscriptions(references);
            } catch (DatabaseException e) {
                ErrorLogger.defaultLogError(e);
            }
        } else {
            final List<VariableReference> references = ISelectionUtils.filterSelection((ISelection) data, VariableReference.class);
            if (!references.isEmpty()) {
                addSubscriptions(references);
            }
        }
    }

    private void addSubscriptions(List<VariableReference> references) {
        SimanticsUI.getSession().asyncRequest(new AddSubscriptionItems(resource, references), new Callback<DatabaseException>() {
            @Override
            public void run(DatabaseException e) {
                if (e != null)
                    ErrorLogger.defaultLogError(e);
            }
        });
    }

}
