/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.model;

import org.simantics.browsing.ui.common.node.IDeletable;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.db.Resource;
import org.simantics.structural.ui.modelBrowser.nodes.AbstractNode;
import org.simantics.ui.SimanticsUI;

/**
 * @author Tuukka Lehtonen
 */
public class StateNode extends AbstractNode implements IDeletable, IModifiableNode {

    public StateNode(Resource resource) {
        super(resource);
    }

    @Override
    public Modifier getModifier(String columnId) {
        // FIXME: the labeler contribution responsible for handling this node does not handle modifiers.
        return new LabelModifier(SimanticsUI.getSession(), resource);
    }

}
