/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.model;

import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.browsing.ui.common.node.IDeletable;
import org.simantics.browsing.ui.common.node.IDropTargetNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.modeling.PropertyVariables;
import org.simantics.structural.ui.modelBrowser.nodes.AbstractNode;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ChartNode extends AbstractNode implements IDeletable, IDropTargetNode, IModifiableNode {

    public ChartNode(Resource resource) {
        super(resource);
    }

    @Override
    public void drop(Object data) {
        if (!(data instanceof ISelection))
            return;

        final List<PropertyVariables> vars = ISelectionUtils.filterSelection((ISelection) data, PropertyVariables.class);
        if (!vars.isEmpty()) {
//            try {
//                List<VariableReference> references = SimanticsUI.getSession().syncRequest(VariableReferences.toReferences(vars));
//                addPlots(references);
//            } catch (DatabaseException e) {
//                ErrorLogger.defaultLogError(e);
//            }
        } else {
            /*
            final List<NodeReference> references = ISelectionUtils.filterSelection((ISelection) data, NodeReference.class);
            if (!references.isEmpty()) {
                addPlots(references);
            }
            */
        }
    }

//    private void addPlots(List<VariableReference> references) {
//        SimanticsUI.getSession().asyncRequest(new AddChartItem(resource, references), new Callback<DatabaseException>() {
//            @Override
//            public void run(DatabaseException e) {
//                if (e != null)
//                    ErrorLogger.defaultLogError(e);
//            }
//        });
//    }

    @Override
    public Modifier getModifier(String columnId) {
        Session s = SimanticsUI.getSession();
        return new LabelModifier(s, resource);
    }

}
