/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.documents;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class OpenMappedDocumentAdapter extends AbstractResourceEditorAdapter {

    private static final String EDITOR_ID = "org.simantics.document.ui.editor";

    public OpenMappedDocumentAdapter() throws MalformedURLException {
        super("Document Editor", ImageDescriptor.createFromURL(new URL("platform:/plugin/com.famfamfam.silk/icons/table.png")));
    }

    protected String getEditorId() {
        return EDITOR_ID;
    }

    @Override
    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        return g.isInstanceOf(r, DiagramResource.getInstance(g).Element);
    }

    @Override
    public void openEditor(final Resource element) throws Exception {
        Simantics.getSession().asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph graph) throws DatabaseException {

            	final Resource component = graph.getPossibleObject(element, ModelingResources.getInstance(graph).ElementToComponent);
            	if(component == null) return;

                Variable variable = graph.adapt(component, Variable.class);
                final Resource model = Variables.getModel(graph, variable);
                final RVI rvi = variable.getRVI(graph);
//                final String RVI = Variables.getPossibleRVI(graph, variable);
//                final String variableURI = variable.getURI(graph);

                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            String editorId = getEditorId();
                            if(rvi != null)
                            	WorkbenchUtils.openEditor(editorId, new ResourceEditorInput2(editorId, component, model, rvi));
//                            else 
//                            	WorkbenchUtils.openEditor(editorId, new ResourceEditorInput2(editorId, component, variableURI, null));
                        } catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

}
