package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.ui.fonts.FontDescriptor;

public class RealizedFontAdapter extends SimpleContextualAdapter<FontDescriptor, RelationContext> {

	@Override
	public FontDescriptor adapt(ReadGraph graph, Resource source, RelationContext context) throws DatabaseException {
		
		DiagramResource DIA = DiagramResource.getInstance(graph);
		Resource font = context.getStatement().getObject();
		
		String family = graph.getRelatedValue(font, DIA.RealizedFont_HasFamily, Bindings.STRING);
		int size = graph.getRelatedValue(font, DIA.RealizedFont_HasSize, Bindings.INTEGER);
		int style = graph.getRelatedValue(font, DIA.RealizedFont_HasStyle, Bindings.INTEGER);
		
		return new Font(family, style, size);
		
	}

}
