/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.elements.MonitorClass;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.ElementWriter;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.utils.Alignment;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.strings.StringUtils;

public class MonitorWriter implements ElementWriter {

    public static final Object LABEL = new Object();

    @Override
    public void addToGraph(WriteGraph g, IElement element, Resource elementResource) throws DatabaseException {

        Resource monitorComponent = element.getHint(MonitorClass.KEY_MONITOR_COMPONENT);
        if (monitorComponent == null)
            throw new IllegalArgumentException("KEY_MONITOR_COMPONENT hint not set");

        Layer0 L0 = Layer0.getInstance(g);
        Layer0X L0X = Layer0X.getInstance(g);
        G2DResource G2D = G2DResource.getInstance(g);
        DiagramResource DIA = DiagramResource.getInstance(g);

        if (!g.hasStatement(elementResource, L0X.ObtainsProperty)) {
            Resource model = g.syncRequest(new PossibleIndexRoot(elementResource));
            if (model != null) {
                Resource template = g.getPossibleObject(model, DIA.HasDefaultMonitorTemplate);
                if (template != null)
                    g.claim(elementResource, L0X.ObtainsProperty1, null, template);
            }
        }

        String label = "";
        g.claimLiteral(elementResource, L0.HasLabel, label);

        Double ddir = element.getHint(MonitorClass.KEY_DIRECTION);
        if (ddir != null)
            DiagramGraphUtil.setRelatedValue(g, elementResource, DIA.HasDirection, L0.Double, ddir, Bindings.DOUBLE);

        if (g.isInstanceOf(monitorComponent, DIA.Element)) {
            ModelingResources MOD = ModelingResources.getInstance(g);
            Resource component = g.getPossibleObject(monitorComponent, MOD.ElementToComponent);
            if (component != null)
                monitorComponent = component;
        }

        g.claim(elementResource, DIA.HasMonitorComponent, monitorComponent);

        final String monitorSuffix = StringUtils.safeString( (String) element.getHint(MonitorClass.KEY_MONITOR_SUFFIX) );
        g.claimLiteral(elementResource, DIA.HasMonitorSuffix, monitorSuffix, Bindings.STRING);

        Double borderWidth = element.getHint(MonitorClass.KEY_BORDER_WIDTH);
        Alignment hAlign = element.getHint(ElementHints.KEY_HORIZONTAL_ALIGN);
        Alignment vAlign = element.getHint(ElementHints.KEY_VERTICAL_ALIGN);
//        MetricsFormat format = element.getHint(MonitorClass.KEY_NUMBER_FORMAT);
        if (borderWidth != null)
            g.claimLiteral(elementResource, G2D.HasStrokeWidth, borderWidth, Bindings.DOUBLE);
        if (hAlign != null)
            g.claim(elementResource, G2D.HasHorizontalAlignment, toResource(g, hAlign, G2D));
        if (vAlign != null)
            g.claim(elementResource, G2D.HasVerticalAlignment, toResource(g, vAlign, G2D));
//        if (format != null)
//            g.claim(elementResource, DIA.HasFormat, G2DUtils.createMetricsFormat(g, format));
    }

    Resource toResource(ReadGraph g, Alignment alignment, G2DResource g2d) {
        switch (alignment) {
            case LEADING: return g2d.Alignment_Leading;
            case TRAILING: return g2d.Alignment_Trailing;
            case CENTER: return g2d.Alignment_Center;
            default:
                throw new IllegalArgumentException("unsupported alignment: " + alignment);
        }
    }

    @Override
    public void removeFromGraph(WriteGraph graph, Resource elementResource) throws DatabaseException {
    }

}
