package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.ui.fonts.FontDescriptor;

public class CurrentFontSizeFactory extends ReadFactoryImpl<Resource, String> {

	@Override
	public String perform(ReadGraph graph, Resource monitor) throws DatabaseException {
		
		DiagramResource DIA = DiagramResource.getInstance(graph);
		FontDescriptor fd = graph.getPossibleRelatedAdapter(monitor, DIA.HasFont, FontDescriptor.class);
		if(fd != null) return String.valueOf(fd.getSize());
		else return null;
		
	}
	
}
