/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagram;

import java.util.Arrays;

import org.simantics.utils.strings.format.MetricsFormat;
import org.simantics.utils.strings.format.MetricsFormatList;

public final class ValueFormatUtil {

    static String valueStr(Object value_) {
        if (value_ == null)
            return "<null>";
        //return valueStr(value_, "0.0###");
        return valueStr(value_, MetricsFormatList.METRICS_GENERIC);
    }

    public static String valueStr(Object value_, MetricsFormat decimalFormat) {
        if (value_ == null)
            return "<null>";

        Class<?> clazz = value_.getClass();
        //System.out.println("FOO: " + clazz + ": " + value_);
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isPrimitive()) {
                if (double[].class == clazz) {
                    return formatDouble((double[]) value_, decimalFormat);
                } else if (float[].class == clazz) {
                    return formatFloat((float[]) value_, decimalFormat);
                } else if (boolean[].class == clazz) {
                    return formatBoolean((boolean[]) value_);
                } else if (int[].class == clazz) {
                    return formatInteger((int[]) value_);
                } else if (long[].class == clazz) {
                    return formatLong((long[]) value_);
                } else if (byte[].class == clazz) {
                    return formatByte((byte[]) value_);
                } else {
                    return value_.toString();
                }
            } else {
                if (String[].class == clazz) {
                    return formatString((String[]) value_);
                } else {
                    return value_.toString();
                }
            }
        }

        if (Double.class == clazz)
            return formatDouble( (Double) value_, decimalFormat );
        else if (Float.class == clazz)
            return formatFloat(new float[] { (Float) value_ }, decimalFormat);

        // String.class == clazz
        // Boolean.class == clazz
        // Integer.class == clazz
        // Long.class == clazz
        // Byte.class == clazz
        return value_.toString();
    }

    private static String formatDouble(double[] ds, MetricsFormat f) {
        StringBuilder sb = new StringBuilder();
//        DecimalFormat format = new DecimalFormat(f, DecimalFormatSymbols.getInstance(Locale.US));
        boolean first = true;
        for (double d : ds) {
            if (!first)
                sb.append(", ");
            else
                first = false;
            //sb.append(format.format(d));
            sb.append(f.formatValue(d));
        }
        return sb.toString();
    }

    private static String formatDouble(double d, MetricsFormat f) {
        //DecimalFormat format = new DecimalFormat(f, DecimalFormatSymbols.getInstance(Locale.US));
        //return format.format(d);
        return f.formatValue(d);
    }

    private static String formatFloat(float[] ds, MetricsFormat f) {
        StringBuilder sb = new StringBuilder();
        //DecimalFormat format = new DecimalFormat(f, DecimalFormatSymbols.getInstance(Locale.US));
        boolean first = true;
        for (float d : ds) {
            if (!first)
                sb.append(", ");
            else
                first = false;
            //sb.append(format.format(d));
            sb.append(f.formatValue(d));
        }
        return sb.toString();
    }

    private static String formatString(String[] value) {
        if (value.length == 1)
            return value[0];
        else
            return Arrays.toString(value);
    }

    private static String formatBoolean(boolean[] value) {
        if (value.length == 1)
            return Boolean.toString(value[0]);
        else
            return Arrays.toString(value);
    }

    private static String formatInteger(int[] value) {
        if (value.length == 1)
            return Integer.toString(value[0]);
        else
            return Arrays.toString(value);
    }

    private static String formatLong(long[] value) {
        if (value.length == 1)
            return Long.toString(value[0]);
        else
            return Arrays.toString(value);
    }

    private static String formatByte(byte[] value) {
        if (value.length == 1)
            return Byte.toString(value[0]);
        else
            return Arrays.toString(value);
    }

}
