package org.simantics.modeling.ui.actions.style;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import org.simantics.utils.strings.format.MetricsFormat;

public class AWTStyleDialog extends JDialog {

	private static final long serialVersionUID = 6836378345175793069L;
	
	private FontChooser fontChooser;
	private JColorChooser colorChooser;
	private MetricsEditor metricsEditor;
	
	private boolean cancelled = true;
	
	private boolean useFont = true;
	private boolean useColor = true;
	private boolean useFormat = true;
	
	public AWTStyleDialog(Frame owner,boolean useFont, boolean useColor, boolean useFormat) {
		super(owner,"Style",true);
		this.useFont = useFont;
		this.useColor = useColor;
		this.useFormat = useFormat;
		createContents();
	}
	
	public AWTStyleDialog(boolean useFont, boolean useColor, boolean useFormat) {
		super();
		setTitle("Style");
		setModal(true);
		this.useFont = useFont;
		this.useColor = useColor;
		this.useFormat = useFormat;
		createContents();
	}
	
	public void setStartFont(Font font) {
		if (!useFont)
			throw new RuntimeException("Dialog is not configured with font support");
		fontChooser.setCurrentFont(font);
	}
	
	public void setStartColor(Color color) {
		if (!useColor)
			throw new RuntimeException("Dialog is not configured with color support");
		colorChooser.setColor(color);
	}
	
	public void setStartFormat(MetricsFormat format) {
		if (!useFormat)
			throw new RuntimeException("Dialog is not configured with format support");
		metricsEditor.setMetricsFormat(format);
	}
	
	private void createContents() {
		
		JTabbedPane tabbedPane = new JTabbedPane();
		getContentPane().add(tabbedPane,BorderLayout.CENTER);
		if (useFont)
			tabbedPane.addTab("Font", fontChooser = new FontChooser("Sample text"));
		if (useColor)
			tabbedPane.addTab("Color",colorChooser = new JColorChooser(new Color(0, 0, 0)));
		if (useFormat)
			tabbedPane.addTab("Metrics",metricsEditor = new MetricsEditor());
		
		JPanel controlPanel = new JPanel();
		getContentPane().add(controlPanel,BorderLayout.SOUTH);
		controlPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		
		JButton okButton = new JButton("OK");
		controlPanel.add(okButton);
		okButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				cancelled = false;
				AWTStyleDialog.this.setVisible(false);
				AWTStyleDialog.this.dispose();
			}
		});
		
		JButton cancelButton = new JButton("Cancel");
		controlPanel.add(cancelButton);
		cancelButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				AWTStyleDialog.this.setVisible(false);
				AWTStyleDialog.this.dispose();
			}
		});
		
		
		this.addWindowListener(new WindowListener() {
			
			@Override
			public void windowOpened(WindowEvent arg0) {}
			
			@Override
			public void windowIconified(WindowEvent arg0) {}
			
			@Override
			public void windowDeiconified(WindowEvent arg0) {}
			
			@Override
			public void windowDeactivated(WindowEvent arg0) {}
			
			@Override
			public void windowClosing(WindowEvent arg0) {
				if (metricsEditor != null)
					metricsEditor.dispose();
			}
			
			@Override
			public void windowClosed(WindowEvent arg0) {}
			
			@Override
			public void windowActivated(WindowEvent arg0) {}
		});
	}
	
	public boolean isCancelled() {
		return cancelled;
	}
	
	public Font getFont() {
		if (fontChooser != null)
			return fontChooser.getFont();
		return null;
	}
	
	public Color getColor() {
		if (colorChooser != null)
			return colorChooser.getColor();
		return null;
	}
	
	public MetricsFormat getFormat() {
		return metricsEditor != null ? metricsEditor.getFormat() : null;
	}
}

