package org.simantics.modeling.ui.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.runtime.DiagramSelectionUpdater;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.modeling.flags.ExpandFlags;

/**
 * @author Hannu Niemist&ouml;
 * @author Tuukka Lehtonen
 */
public class ExpandFlagsHandler extends FlagOperationHandler {

    @Override
    protected void perform(IProgressMonitor monitor, WriteGraph graph, List<Resource> flags,
            ICanvasContext canvasContext) throws DatabaseException {
        monitor.beginTask("Expand Flags", IProgressMonitor.UNKNOWN);

        Set<Resource> newSelection = new HashSet<Resource>();
        for (Resource flag : flags) {
            Resource[] result = ExpandFlags.expandFlag(graph, flag);
            newSelection.addAll( Arrays.asList(result) );
        }

        // Make sure the diagram selection is set to the
        // merged flag after the merge.
        new DiagramSelectionUpdater( canvasContext )
        .setNewSelection(0, newSelection)
        .setOneshot(true)
        .track();
    }

}
