/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.function;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Map;

public class TranslateFlag {
	public static final float lineWidth = 0.3F;
	private FlagInfo flagInfo = null;
	private Map<String, FlagTableInfo> tables = null;
	private double[] transform = null;
	private double gridSize = 0.0;

	public TranslateFlag(FlagInfo flagInfo, Map<String, FlagTableInfo> tables, double[] transform, double gridSize){
		this.flagInfo = flagInfo;
		this.tables = tables;
		this.transform = transform;
		this.gridSize = gridSize;
	}

	public double[] perform(){
		// flag transforming
		FlagTableInfo table = tables.get(flagInfo.flagTableName);
		if (table == null)
			return this.transform;

//		Double x = table.getPosition().getX()+((table.getAlignment()==TemplateInfo.ALIGN_RIGHT)?table.getWidth():0.0);
//		Double y = table.getPosition().getY()+table.getRowHeigth()*(flagInfo.getSlotTableRowIndex())-2.0F+TemplateInfo.BASELINE_VERTICAL_OFFSET*table.getRowHeigth();
//        double[] copy = Arrays.copyOf(transform, transform.length);
//        copy[4] = x;
//        copy[5] = y;
//        return copy;


		//double yy = table.getRowHeigth()*(flagInfo.getSlotTableRowIndex())-2.0F+TemplateInfo.BASELINE_VERTICAL_OFFSET*table.getRowHeigth();
		double[] tableTrans = table.getTransform();
		double scale = tableTrans[3];
		double scaledRowHeigth = scale*table.getRowHeight();

		// move to coordinate system of parent of iotable
		double rowMiddleY = tableTrans[5]+(flagInfo.flagTableRowIndex+0.5F)*scaledRowHeigth;
		if (gridSize != 0.0) {
			double modulo = rowMiddleY%gridSize;
			int count =(int) (rowMiddleY/gridSize);
			double gridOnRow = (modulo > (gridSize/2))?gridSize*(1+count):gridSize*count;
			double diff = (gridOnRow > rowMiddleY)? gridOnRow - rowMiddleY:rowMiddleY-gridOnRow;
			if (diff < (scaledRowHeigth/2))
				rowMiddleY = gridOnRow; 
		}
		// move back to iotable coordinate system
		rowMiddleY = (rowMiddleY-tableTrans[5])/scale;

//		double yy = 0.0;
//		yy = (flagInfo.getSlotTableRowIndex()+0.5F)*table.getRowHeigth()-lineWidth/2;
//		double yy2 = 0.0;
//
//		// calculate flag position if it is snap to grid
//		if (gridSize != 0.0) {
//			double modulo = yy%gridSize;
//			int count =(int) (yy/gridSize);
//			yy2 = ((yy%gridSize) > (gridSize/2))?gridSize*(1+ (int)(yy/gridSize))-lineWidth/2:gridSize*(int)(yy/gridSize)-lineWidth/2;
//		}
//
//		// check that the nearist grid layes on current row
//		if (yy2-yy < table.getRowHeigth()/2)
//			yy = yy2;

		double xx = ((table.getAlignment()==DrawingTemplateInfo.ALIGN_RIGHT)?table.getWidth():0.0); 

		AffineTransform trans = new AffineTransform(new double[]{tableTrans[0],tableTrans[1],tableTrans[2],tableTrans[3],0.0,0.0});
		Point2D point = new Point2D.Double(xx, rowMiddleY);
		trans.transform(point, point);

		double[] copy = Arrays.copyOf(transform, transform.length);
		copy[4] = tableTrans[4] + point.getX();
		copy[5] = tableTrans[5] + point.getY();
		return copy;
//		Double x = table.getTransform()[4]+;
//		Double y = table.getTransform()[5]+;
//		
//        double[] copy = Arrays.copyOf(transform, transform.length);
//        copy[4] = x;//transform[4];
//        copy[5] = y;
//        return copy;

//        Session session = Simantics.peekSession();
//        if (session == null)
//        	return;
//        session.asyncRequest(new WriteRequest(){
//			@Override
//			public void perform(WriteGraph g) throws DatabaseException {
//				TranslateElement.absolute(flagInfo.getFlag(), position).perform(g);
//			}});
	}
}
