package org.simantics.modeling.template2d.ui.export;

import java.io.File;
import java.util.Collections;
import java.util.List;

import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.RecordType;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.FormatClass;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.manager.TransferableGraphReader;
import org.simantics.export.core.manager.TransferableGraphWriter;
import org.simantics.modeling.template2d.DiagramTemplateConstants;

public class DrawingTemplateFormat implements FormatClass {

	@Override
	public Object createFile(ExportContext context, File outputFile, Variant options) throws ExportException {
		return new TransferableGraphWriter(
				outputFile, 
				DiagramTemplateConstants.DRAWING_TEMPLATE_FORMAT,
				DiagramTemplateConstants.DRAWING_TEMPLATE_CURRENT_VERSION);
	}

	@Override
	public Object openFile(ExportContext context, File inputFile, Variant options) throws ExportException {
		return new TransferableGraphReader( inputFile );
	}

	@Override
	public List<String> validate(ExportContext context, Variant options) throws ExportException {
		return Collections.emptyList();
	}
	
	@Override
	public void closeFile(ExportContext context, Object handle) throws ExportException {
		// TODO Auto-generated method stub
		
	}
	
	@Override
	public void addAttachment(ExportContext context, Object handle, List<Content> attachments) throws ExportException {
		throw new ExportException( "Cannot add attachments to Transferable Graph file." );
	}

	@Override
	public RecordType options(ExportContext context) throws ExportException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void fillDefaultPrefs( ExportContext ctx, Variant options ) throws ExportException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void savePref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void loadPref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
		// TODO Auto-generated method stub
		
	}

}
