package org.simantics.modeling.template2d.ui.export;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.RecordType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.request.Read;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.ExportClass;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.manager.TransferableGraphWriter;
import org.simantics.export.core.util.ExportQueries;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.utils.datastructures.MapList;

public class DrawingTemplateExporter implements ExportClass {

	@Override
	public RecordType options(ExportContext context, Collection<String> content) throws ExportException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void fillDefaultPrefs(ExportContext ctx, Variant options) throws ExportException {
		// TODO Auto-generated method stub
	}

	@Override
	public void savePref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
		// TODO Auto-generated method stub
	}

	@Override
	public void loadPref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
		// TODO Auto-generated method stub
	}

	@Override
	public void export(List<Content> contents, 
			Object writer_,
			ExportContext context, 
			Variant options,
			IProgressMonitor monitor, 
			MapList<Content, Content> attachmentMap
			) throws ExportException {
				
		final TransferableGraphWriter writer = (TransferableGraphWriter) writer_;
		
        try {
    		List<Resource> resources = context.session.syncRequest( ExportQueries.toResources2(contents) );
    		for ( final Resource model : resources ) {
	            // TODO: figure out a way to make the TG go directly into a file
	            // instead of having it all in memory at once.
	            SimanticsClipboard clipboard = context.session.syncRequest(new Read<SimanticsClipboard>() {
	                @Override
	                public SimanticsClipboard perform(ReadGraph graph) throws DatabaseException {
	                    CopyHandler ch = graph.adapt( model, CopyHandler.class );
	                    SimanticsClipboardImpl clipboard = new SimanticsClipboardImpl();
	                    ch.copyToClipboard(graph, clipboard);
	                    return clipboard;
	                }
	            });
	            for (Set<Representation> object : clipboard.getContents()) {
	                TransferableGraph1 tg = ClipboardUtils.accept(object, SimanticsKeys.KEY_TRANSFERABLE_GRAPH);                    
	                writer.writeFile(TransferableGraph1.BINDING, tg);
	            }
    		}

        } catch (DatabaseException e) {
        	throw new ExportException(e);
		}

	}

	@Override
	public List<String> validate(String contentUri, ExportContext context, Variant options) {
		return Collections.emptyList();
	}

}
