/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.diagram.adapter;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.g2d.scenegraph.SceneGraphConstants;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.modeling.template2d.ui.function.All;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.loader.ScenegraphLoaderProcess;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.common.ProfileVariables;


public class DrawingTemplateStyle extends StyleBase<INode> {

	private static final String PAGE_TEMPLATE_NODE_NAME = "pageTemplate";

	private static Resource getTemplateScenegraph(ReadGraph graph, Resource runtimeDiagram) throws DatabaseException {
		Template2dResource TEMPLATE2D = Template2dResource.getInstance(graph);
		Resource template = All.getTemplate(graph, runtimeDiagram);
		if (template == null)
			return null;
		return graph.getPossibleObject(template, TEMPLATE2D.HasScenegraph);
	}

	@Override
	public INode calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem, Variable activeComposite)
			throws DatabaseException {
		Resource sceneGraph = DrawingTemplateStyle.getTemplateScenegraph(graph, runtimeDiagram);
		if (sceneGraph == null)
			return null;
		ScenegraphLoaderProcess loader = new ScenegraphLoaderProcess(new G2DParentNode(), "TemplateStyle.calculate");
		return loader.load(graph, sceneGraph, runtimeDiagram);
	}

	@Override
	public void applyStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item, INode node) {
		if (node == null)
			return;

		G2DSceneGraph sg = evaluationContext.getSceneGraph();
		if (sg == null)
			return;
		G2DParentNode nav = (G2DParentNode) sg.getNode(SceneGraphConstants.NAVIGATION_NODE_NAME);
		if (nav == null)
			return;

		SingleElementNode pageTemplate = ProfileVariables.claimChild(evaluationContext.getSceneGraph(),
				SceneGraphConstants.NAVIGATION_NODE_NAME, PAGE_TEMPLATE_NODE_NAME, SingleElementNode.class,
				evaluationContext);

		if (pageTemplate == null)
			return;

		pageTemplate.setZIndex(1);
		pageTemplate.setVisible(true);

		// Switch template contents if the contents are not exactly the same.
		INode previous = pageTemplate.getNode("structure");
		if (previous != node) {
			pageTemplate.detachNode("structure");
			pageTemplate.attachNode("structure", node);
		}
	}

	@Override
	protected void cleanupStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item) {
		G2DSceneGraph sg = evaluationContext.getSceneGraph();
		if (sg == null)
			return;
		G2DParentNode nav = (G2DParentNode) sg.getNode(SceneGraphConstants.NAVIGATION_NODE_NAME);
		if (nav == null)
			return;

		G2DParentNode pageTemplate = (G2DParentNode) nav.getNode(PAGE_TEMPLATE_NODE_NAME);
		if (pageTemplate == null)
			return;

		pageTemplate.detachNode("structure");
		ProfileVariables.denyChild(evaluationContext.getSceneGraph(),
				SceneGraphConstants.NAVIGATION_NODE_NAME, PAGE_TEMPLATE_NODE_NAME);
	}

	@Override
	public String toString() {
		return "Template";
	}

}
