/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.actions;

import java.awt.Color;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.ui.SimanticsUI;

public class SetBorderColor implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource parent = (Resource)target;
        
        return new Runnable() {
            @Override
            public void run() {
                // PlatformUI.getWorkbench().getDisplay().getActiveShell()
                IWorkbenchWindow  win = PlatformUI.getWorkbench().getActiveWorkbenchWindow(); //.getDisplay().getActiveShell()
                //Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                if (win == null)
                	return;
                
                Shell shell = win.getShell();
                if (shell == null)
                	return;
                
                ColorDialog dia = new ColorDialog(shell); //.get Display.getDefault().getActiveShell()
                final RGB rgb = dia.open();
                if (rgb == null)
                	return;


                SimanticsUI.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        
//                        Layer0 L0 = Layer0.getInstance(g);
                        Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);
                        G2DResource G2D = G2DResource.getInstance(g);
                        
                        if (!g.isInstanceOf(parent, TEMPLATE2D.Border))
                        	return;
                        
                        Resource oldColor = g.getPossibleObject(parent, G2D.HasColor);
                        Resource color = G2DUtils.createColor(g, new Color(rgb.red, rgb.green, rgb.blue));
                        if (oldColor != null)
                        	g.deny(oldColor);
                        g.claim(parent, G2D.HasColor, color);
                    }
                });
            }
        };
    }
}
