/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.ui.SimanticsUI;

/**
 * @author Teemu Matasniemi
 */
public class NewFlagTableColumn implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource parent = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        
                        Layer0 L0 = Layer0.getInstance(g);
                        Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);
                        ScenegraphResources SG = ScenegraphResources.getInstance(g);
                        DiagramResource DIA = DiagramResource.getInstance(g);
                        G2DResource G2D = G2DResource.getInstance(g);

                        Resource resource = g.newResource();
                        claimColumn(g, resource, parent);
                        g.claim(resource, L0.InstanceOf, null, TEMPLATE2D.FlagTableUI_ColumnUI);
                        g.addLiteral(resource, DIA.Scenegraph_Composite_transform, DIA.Scenegraph_Composite_transform_Inverse, G2D.Transform, new double[] { 1.0, 0.0, 0.0, 1.0, 0.0, 0.0 }, Bindings.getBindingUnchecked(double[].class));
                        g.claim(resource, SG.Node_children, ListUtils.create(g, new ArrayList<Resource>()));
                        g.claim(resource, L0.PartOf, parent);

                        Resource list = g.getPossibleObject(parent, SG.Node_children);
                        if (list != null)
                            ListUtils.insertBack(g, list, Arrays.asList(resource));

                        NewFlagTableColumnHeader createHeader = new NewFlagTableColumnHeader();
                        Runnable createHeaderCmd = createHeader.create(resource);
                        createHeaderCmd.run();

                        NewFlagTableColumnData createData = new NewFlagTableColumnData();
                        Runnable createDataCmd = createData.create(resource);
                        createDataCmd.run();
                    }
                });
            }
        };
    }

    protected void claimColumn(WriteGraph g, Resource column, Resource parent) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);
        g.claim(column, L0.InstanceOf, null, TEMPLATE2D.FlagTable_Column);
        String name = NameUtils.findFreshName(g, "Column", parent, L0.ConsistsOf);
        g.addLiteral(column, L0.HasName, L0.NameOf, L0.String, name, Bindings.STRING);
    }

}
