/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.actions;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.ui.SimanticsUI;

public class ChangePageOrientation implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource parent = (Resource)target;
        
        return new Runnable() {
            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);
                        
                        if (!g.isInstanceOf(parent, TEMPLATE2D.DrawingTemplate))
                        	return;
                        
                        Resource oldOrientation = g.getPossibleObject(parent, TEMPLATE2D.HasPageOrientation);
                        if (oldOrientation == null)
                        	return;
                        
                        g.deny(parent, TEMPLATE2D.HasPageOrientation);
                        if (oldOrientation.equals(TEMPLATE2D.PageOrientation_Landscape))
                        	g.claim(parent, TEMPLATE2D.HasPageOrientation, TEMPLATE2D.PageOrientation_Portrait);
                        else
                        	g.claim(parent, TEMPLATE2D.HasPageOrientation, TEMPLATE2D.PageOrientation_Landscape);
                    }
                });
            }
        };
    }
}
