/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.subscription;

import java.util.UUID;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

/**
 * This query returns SubscriptionItem description
 * 
 * @author Antti Villberg
 */
public class SubscriptionItemQuery extends ResourceRead<SubscriptionItem> {

	public SubscriptionItemQuery(Resource resource) {
		super(resource);
	}

	@SuppressWarnings("unused")
	@Override
	public SubscriptionItem perform(ReadGraph graph) throws DatabaseException {
		
        ModelingResources MOD = ModelingResources.getInstance(graph);
        Layer0 L0 = Layer0.getInstance(graph);

        SubscriptionItem item = new SubscriptionItem();
        
        item.variableId = "";
        item.groupItemId = "";
        Resource subscriptionItem = resource;
        Resource subscription = null;
        if (subscriptionItem!=null) {
        	item.simpleLabel = graph.getPossibleRelatedValue(subscriptionItem, L0.HasLabel, Bindings.STRING);
            subscription = graph.syncRequest( new PossibleTypedParent(subscriptionItem, MOD.Subscription) );        	
        }
        if (item.simpleLabel==null) item.simpleLabel = "";
        if (subscriptionItem != null) 
        	SubscriptionItem: { 
		
		        label2: {
        			item.groupItemId = graph.getPossibleRelatedValue(subscriptionItem, L0.HasName, Bindings.STRING);
        			if (item.groupItemId == null) break SubscriptionItem;

        			Binding rviBinding = graph.getService(Databoard.class).getBindingUnchecked( RVI.class );
		            RVI rvi = graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_VariableId, rviBinding);
		            if (rvi == null) break SubscriptionItem;        
		            //variablePersistentId = rvi.toString();
		            
					Variable configuration = Variables.getPossibleConfigurationContext(graph, subscription);
					if (configuration == null) break SubscriptionItem;
					
					Resource activeExperiment = graph.syncRequest(new PossibleActiveExperiment(subscription));
					if (activeExperiment != null) {
						Variable experimentVariable = null;
						try {
							experimentVariable = Variables.switchRealization(graph, configuration, activeExperiment);
						} catch (DatabaseException e) {
							experimentVariable = Variables.switchPossibleContext(graph, configuration, activeExperiment);
						}
						if (experimentVariable != null) {
							configuration = experimentVariable;
						}
					}

					item.variableId = item.variableReference = rvi.toPossibleString(graph, configuration);
		            if (item.variableId == null) break SubscriptionItem;

		            if (item.simpleLabel.isEmpty()) {
		            	item.simpleLabel = SubscriptionItemLabel.removeVariablePrefixPath( item.variableId );
		            }
		        }
		        
		    	subscription: {
		            if (subscription!=null) {
		                item.groupId = graph.getPossibleRelatedValue(subscription, L0.HasName, Bindings.STRING);
		            } else {
		                item.groupId = UUID.randomUUID().toString();
		            }
		    	}
		        
		        unit: {
		            item.unit = graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Unit, Bindings.STRING);
		        }
		    	
        } 
        
        if (item.groupItemId==null) item.groupItemId = "";
        if (item.variableId==null) item.variableId = "";
        if (item.groupId==null) item.groupId = "";
        if (item.unit==null) item.unit = "";
        
        return item;
	}

}
