package org.simantics.modeling.subscription;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.simulation.ontology.SimulationResource;

/**
 * @author Tuukka Lehtonen
 * @since 1.18.1
 */
public class ModelContextsRequest extends ResourceRead<ModelContexts> {

    public ModelContextsRequest(Resource model) {
        super(model);
    }

    @Override
    public ModelContexts perform(ReadGraph graph) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance(graph);
        Resource configurationResource = graph.getPossibleObject(resource, SIMU.HasConfiguration);
        Variable configurationContext = configurationResource != null ? Variables.getPossibleVariable(graph, configurationResource) : null;
        Resource run = graph.sync(new PossibleActiveExperiment(resource));
        Variable experimentContext = run != null ? Variables.getPossibleVariable(graph, run) : null;
        String configurationContextURI = configurationContext != null ? configurationContext.getURI(graph) : null; 
        String experimentContextURI = experimentContext != null ? experimentContext.getURI(graph) : null; 
        return new ModelContexts(resource, configurationContext, experimentContext, configurationContextURI, experimentContextURI);
   }

}