package org.simantics.modeling.scl;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

public class SCLSessionManager {
    static ConcurrentHashMap<String, SCLRealm> CONNECTIONS =
            new ConcurrentHashMap<String, SCLRealm>(); 
    
    static ConcurrentHashMap<String, NodeSupport<String>> SUPPORTS =
            new ConcurrentHashMap<String, NodeSupport<String>>(); 
    
    public static SCLRealm sclRealmById(String id) {
        // CONNECTIONS is ConcurrentHashMap so no synchronization is needed here
        return CONNECTIONS.get(id);
    }
    
    public static synchronized NodeSupport<String> getOrCreateNodeSupport(String id) {
        NodeSupport<String> result = SUPPORTS.get(id);
        if(result == null) {
            SCLRealm realm = getOrCreateSCLRealm(id);
            result = new NodeSupport<String>(realm.getNodeManager());
            SUPPORTS.put(id, result);
        }
        return result;
    }
    
    public static synchronized SCLRealm createRealm() {
        String id = UUID.randomUUID().toString();
        return createRealm(id);
    }
    
    public static synchronized SCLRealm getOrCreateSCLRealm(String id) {
        SCLRealm session = sclRealmById(id);
        if(session == null)
            return createRealm(id);
        else
            return session;
    }
    
    private static SCLRealm createRealm(String id) {
        CommandSession connection = new CommandSession(SCLOsgi.MODULE_REPOSITORY, SCLReportingHandler.DEFAULT);
        SCLRealm realm = new SCLRealm(connection, id);
        CONNECTIONS.put(id, realm);
        return realm;
    }
    
    public static synchronized void removeRealm(String id) {
        CONNECTIONS.remove(id);
        // if node support has been created remove it as well
        SUPPORTS.remove(id);
    }
}
