package org.simantics.modeling.scl;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural2.scl.CompileStructuralValueRequest;

public class CompileSCLValueRequest extends CompileStructuralValueRequest {

    public CompileSCLValueRequest(ReadGraph graph, Variable context)
            throws DatabaseException {
        super(graph, context);
    }

    public static Object compileAndEvaluate(ReadGraph graph, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get("graph");
        try {
            Function1<Variable,Object> exp = graph.syncRequest(new CompileSCLValueRequest(graph, context),
                    TransientCacheListener.<Function1<Variable,Object>>instance());
            sclContext.put("graph", graph);
            return exp.apply(context);
        } catch (DatabaseException e) {
            throw (DatabaseException)e;
        } catch (Throwable t) {
            throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
    }
    
}
