/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.requests;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;

import org.eclipse.jface.viewers.IFilter;
import org.simantics.db.Resource;
import org.simantics.scl.runtime.function.Function1;

/**
 * @author Tuukka Lehtonen
 */
public class CollectionResult {

    public class DiagramFilter implements IFilter {

        private final IFilter proxy;

        public DiagramFilter(IFilter proxy) {
            this.proxy = proxy;
        }

        @Override
        public boolean select(Object node) {
            return diagramSet.contains(node) && (proxy == null || proxy.select(node));
        }

    }

    final public Set<Node>           roots       = new ConcurrentSkipListSet<Node>();
    final private Set<Node>          diagramSet  = new ConcurrentSkipListSet<Node>();
    final public List<Node>          diagramList = new Vector<Node>();
    final public Map<Resource, Node> diagrams    = new ConcurrentHashMap<Resource, Node>();

    public void addDiagram(Resource r, Node n) {
        diagramList.add(n);
        diagrams.put(r, n);
        diagramSet.add(n);
    }

    public Collection<Node> breadthFirstFlatten() {
        return breadthFirstFlatten(null);
    }

    public Collection<Node> breadthFirstFlatten(IFilter filter) {
        return Nodes.breadthFirstFlatten(new DiagramFilter(filter), roots);
    }

    public Collection<Node> depthFirstFlatten() {
        return depthFirstFlatten(null, null);
    }

    public Collection<Node> depthFirstFlatten(IFilter filter, Comparator<? super Node> comparator) {
        return Nodes.depthFirstFlatten(new DiagramFilter(filter), roots, comparator);
    }

    /**
     * @param f
     *            function that takes the walked Node as argument and returns a
     *            boolean to describe whether to continue the walk or cancel the
     *            walk. The returned value cannot be <code>null</code>.
     * @return <code>true</code> if the walk was completed or <code>false</code>
     *         if the walk was cancelled
     */
    public boolean walkTree(Function1<Node, Boolean> f) {
        return Nodes.walkTree(f, roots);
   }

}