/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.preferences;

import java.text.DecimalFormatSymbols;
import java.util.Locale;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.Preferences;

/**
 * @author Toni Kalajainen
 */
public class CSVPreferenceInitializer extends AbstractPreferenceInitializer {

    public void initializeDefaultPreferences() {
        IScopeContext context = DefaultScope.INSTANCE;
        Preferences node = context.getNode(CSVPreferences.P_NODE);
        
        // 1. figure decimal separator
        Locale locale = Locale.getDefault();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance( locale );
        String decimalSeparator = symbols.getDecimalSeparator()+""; 
        node.put( CSVPreferences.P_CSV_DECIMAL_SEPARATOR, decimalSeparator );
        
        // 2. Then figure out value separator
        String valueSeparator = decimalSeparator.equals(",")?"\\t":",";
        node.put( CSVPreferences.P_CSV_COLUMN_SEPARATOR, valueSeparator );
        
        node.put( CSVPreferences.P_CSV_FILE_EXTENSION, CSVPreferences.DEFAULT_FILE_EXTENSION );
        
        node.putDouble(CSVPreferences.P_CSV_START_TIME, CSVPreferences.DEFAULT_CSV_START_TIME);
        node.putDouble(CSVPreferences.P_CSV_TIME_STEP, CSVPreferences.DEFAULT_CSV_TIME_STEP);

        node.putBoolean(CSVPreferences.P_CSV_RESAMPLE, CSVPreferences.DEFAULT_CSV_RESAMPLE);
        
        node.put(CSVPreferences.P_CSV_SAMPLING_MODE, CSVPreferences.DEFAULT_CSV_SAMPLING_MODE);

        node.putInt(CSVPreferences.P_CSV_TIME_DIGITS, CSVPreferences.DEFAULT_CSV_TIME_DIGITS);
        node.putInt(CSVPreferences.P_CSV_FLOAT_DIGITS, CSVPreferences.DEFAULT_CSV_FLOAT_DIGITS);
        node.putInt(CSVPreferences.P_CSV_DOUBLE_DIGITS, CSVPreferences.DEFAULT_CSV_DOUBLE_DIGITS);
    }

}
