package org.simantics.modeling.mapping;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.modeling.mapping.ComponentAndElementCopyHandler;
import org.simantics.modeling.mapping.ComponentAndElementPasteImportAdvisor;

/**
 * TG-based ElementCopyAdvisor.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class TGElementCopyAdvisor extends ElementCopyAdvisor {
	
	public Object copy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer,
            Resource targetContainer, Map<Object, Object> map) throws DatabaseException {
		

		DiagramResource DIA = DiagramResource.getInstance(graph);
		if (!graph.isInstanceOf(source, DIA.Connection)) {
			// Connections cannot be copied with TG. 
			SimanticsClipboardImpl builder = new SimanticsClipboardImpl();
			
			ComponentAndElementCopyHandler handler = new ComponentAndElementCopyHandler(source,false,true) {
				@Override
				protected void processElement(ReadGraph graph, Resource element,
						boolean includeElement, ArrayList<NamedResource> roots,
						ArrayList<Resource> exclusions) throws DatabaseException {
					super.processElement(graph, element, includeElement, roots, exclusions);
					TGElementCopyAdvisor.this.processElement(graph, element, includeElement, roots, exclusions);
				}
			};
			
			ComponentAndElementPasteImportAdvisor advisor = new ComponentAndElementPasteImportAdvisor(graph, targetContainer, false,true);
			
			handler.copyToClipboard(graph, builder);
			for(Set<Representation> object : builder.getContents()) {
	            TransferableGraph1 tg = ClipboardUtils.accept(graph, object, SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
	            if(tg != null) {
	                
	                TransferableGraphs.importGraph1(graph, tg, advisor);
	                advisor.attach(graph);
	                Resource copy = advisor.getElement();
	                map.put(source, copy);
	                return copy;
	            }
	        }
		} else {
			return super.copy(context, graph, source, sourceContainer, targetContainer, map);
		}
		
		 throw new DatabaseException("Failed to copy resource " + NameUtils.getSafeName(graph, source, true)
	                + " under " + NameUtils.getSafeName(graph, targetContainer, true));
	}

	/**
	 * Callback for custom element handling.
	 * 
	 * @param graph
	 * @param element
	 * @param includeElement
	 * @param roots
	 * @param exclusions
	 * @throws DatabaseException
	 */
	protected void processElement(ReadGraph graph, Resource element, boolean includeElement, ArrayList<NamedResource> roots, ArrayList<Resource> exclusions) throws DatabaseException {
		
	}
}
