package org.simantics.modeling.internal;

import java.util.Hashtable;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.simantics.modeling.scl.GraphModuleSourceRepository;
import org.simantics.modeling.scl.OntologyModuleSourceRepository;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;

public class Activator implements BundleActivator {

    private static BundleContext context;
    
    @SuppressWarnings({ "rawtypes", "unchecked" })
    @Override
    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        Hashtable properties = new Hashtable();
        
        context.registerService(ModuleSourceRepository.class, OntologyModuleSourceRepository.INSTANCE, properties);
        context.registerService(ModuleSourceRepository.class, GraphModuleSourceRepository.INSTANCE, properties);
    }

    @Override
    public void stop(BundleContext context) throws Exception {
    }

    public static BundleContext getContext() {
        return context;
    }
}
